/******************************************************************************
 *    FILENAME : Bsp_Adc.c
 *
 *    PURPOSE  : ADC Initialization & Support Functions.
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/
#include "Bsp_Adc.h"

//=============================================================================
// *  Variables & Function_Defines
//=============================================================================
int Bat_volt=0;

//=============================================================================
// * FUNCTION: Adc_PowerOn()
// * PURPOSE :
// *
// * CALLED BY:
//=============================================================================
void Adc_PowerOn(void)
{
    // extern void DSP28x_usDelay(Uint32 Count);

    // *IMPORTANT*
    // The Device_cal function, which copies the ADC calibration values from TI reserved
    // OTP into the ADCREFSEL and ADCOFFTRIM registers, occurs automatically in the
    // Boot ROM. If the boot ROM code is bypassed during the debug process, the
    // following function MUST be called for the ADC to function according
    // to specification. The clocks to the ADC MUST be enabled before calling this
    // function.
    // See the device data manual and/or the ADC Reference
    // Manual for more information.

    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 1;
    (*Device_cal)();
    EDIS;

    // To powerup the ADC the ADCENCLK bit should be set first to enable
    // clocks, followed by powering up the bandgap, reference circuitry, and ADC core.
    // Before the first conversion is performed a 5ms delay must be observed
    // after power up to give all analog circuits time to power up and settle

    // Please note that for the delay function below to operate correctly the
    // CPU_RATE define statement in the DSP2803x_Examples.h file must
    // contain the correct CPU clock period in nanoseconds.
    EALLOW;
    AdcRegs.ADCCTL1.bit.ADCBGPWD  = 1;      // Power ADC BG
    AdcRegs.ADCCTL1.bit.ADCREFPWD = 1;      // Power reference
    AdcRegs.ADCCTL1.bit.ADCPWDN   = 1;      // Power ADC
    AdcRegs.ADCCTL1.bit.ADCENABLE = 1;      // Enable ADC
    AdcRegs.ADCCTL1.bit.ADCREFSEL = 1;      // Select out BG
    EDIS;

    DELAY_US(5000);         // Delay 5ms before converting ADC channels

}



//============================================================================
// * Function    :  InitAdc
// * Purpose     :  ADCԴģʽͨӳ䡢Դж.
// * Parameters  :  Null
// * Return      :  Null
//============================================================================

void InitAdc(void)
{
    Adc_PowerOn();  // ADCģԴִУȷADCȶ

    EALLOW;         // "ܱĴģʽ"

/************************** 1. ADCģʽ **************************/
    // ADCSAMPLEMODEĴƲģʽ˳/ͬ
    // SIMULENxλ0=˳Sequential1=ͬSimultaneous
    // ˳SOC0SOC1SOC15˳תǰһɺһ
    // ͬSOCͬʱתʺ϶ͨв
    // ˴SIMULENλ  SOC**˳**
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN0  =   0;  // SOC0~SOC1  ˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN2  =   0;  // SOC2~SOC3  ˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN4  =   0;  // SOC4~SOC5  ˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN6  =   0;  // SOC6~SOC7  ˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN8  =   0;  // SOC8~SOC9  ˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN10 =   0;  // SOC10~SOC11˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN12 =   0;  // SOC12~SOC13˳
    AdcRegs.ADCSAMPLEMODE.bit.SIMULEN14 =   0;  // SOC14~SOC15˳


/************************** 2. ÿSOCͨӳ **************************/
    // ADCSOCxCTL.CHSELѡSOCӦģͨ
    // F2803516ⲿͨADCINA0~INA7룩ADCINB0~INB7룩
    // CHSELȡֵ0~15Ӧ0=ADCINA01=ADCINA17=ADCINA78=ADCINB015=ADCINB7
    AdcRegs.ADCSOC0CTL.bit.CHSEL    = 0;    // SOC0  ADCINA0
    AdcRegs.ADCSOC1CTL.bit.CHSEL    = 1;    // SOC1  ADCINA1
    AdcRegs.ADCSOC2CTL.bit.CHSEL    = 2;    // SOC2  ADCINA2
    AdcRegs.ADCSOC3CTL.bit.CHSEL    = 3;    // SOC3  ADCINA3
    AdcRegs.ADCSOC4CTL.bit.CHSEL    = 4;    // SOC4  ADCINA4
    AdcRegs.ADCSOC5CTL.bit.CHSEL    = 5;    // SOC5  ADCINA5
    AdcRegs.ADCSOC6CTL.bit.CHSEL    = 6;    // SOC6  ADCINA6
    AdcRegs.ADCSOC7CTL.bit.CHSEL    = 7;    // SOC7  ADCINA7
    AdcRegs.ADCSOC8CTL.bit.CHSEL    = 8;    // SOC8  ADCINB0
    AdcRegs.ADCSOC9CTL.bit.CHSEL    = 9;    // SOC9  ADCINB1
    AdcRegs.ADCSOC10CTL.bit.CHSEL   = 0xA;  // SOC10  ADCINB20xA=10
    AdcRegs.ADCSOC11CTL.bit.CHSEL   = 0xB;  // SOC11  ADCINB30xB=11
    AdcRegs.ADCSOC12CTL.bit.CHSEL   = 0xC;  // SOC12  ADCINB40xC=12
    AdcRegs.ADCSOC13CTL.bit.CHSEL   = 0xD;  // SOC13  ADCINB50xD=13
    AdcRegs.ADCSOC14CTL.bit.CHSEL   = 0xE ; // SOC14  ADCINB60xE=14
    AdcRegs.ADCSOC15CTL.bit.CHSEL   = 0xF;  // SOC15  ADCINB70xF=15


/************************** 3. ÿSOCĲ **************************/
    // ADCSOCxCTL.ACQPS"׶"ʱ
    // ڿ = (ACQPS + 1)  ADCCLK
    // Ҫ󣺲ʱF28035涨Сֵͨ16ADCCLKڣ200ns
    // ˴ACQPS=6  =7ADCCLKڣʵADCCLKȷҪ
    AdcRegs.ADCSOC0CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC1CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC2CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC3CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC4CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC5CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC6CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC7CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC8CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC9CTL.bit.ACQPS    =   6;
    AdcRegs.ADCSOC10CTL.bit.ACQPS   =   6;
    AdcRegs.ADCSOC11CTL.bit.ACQPS   =   6;
    AdcRegs.ADCSOC12CTL.bit.ACQPS   =   6;
    AdcRegs.ADCSOC13CTL.bit.ACQPS   =   6;
    AdcRegs.ADCSOC14CTL.bit.ACQPS   =   6;
    AdcRegs.ADCSOC15CTL.bit.ACQPS   =   6;


/************************** 4. ÿSOCĴԴ **************************/
    // ADCSOCxCTL.TRIGSELѡ񴥷SOCתźԴ
    // 5=ADCTRIG5  ӦePWM1SOCAźţePWM1=0ʱ壩
    // SOCePWM1 SOCA  תаSOC0SOC1SOC15˳ִ
    AdcRegs.ADCSOC0CTL.bit.TRIGSEL  =   5;  // SOC0ԴePWM1 SOCA
    AdcRegs.ADCSOC1CTL.bit.TRIGSEL  =   5;  // SOC1ԴePWM1 SOCAĿͨ
    AdcRegs.ADCSOC2CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC3CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC4CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC5CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC6CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC7CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC8CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC9CTL.bit.TRIGSEL  =   5;
    AdcRegs.ADCSOC10CTL.bit.TRIGSEL =   5;
    AdcRegs.ADCSOC11CTL.bit.TRIGSEL =   5;
    AdcRegs.ADCSOC12CTL.bit.TRIGSEL =   5;
    AdcRegs.ADCSOC13CTL.bit.TRIGSEL =   5;
    AdcRegs.ADCSOC14CTL.bit.TRIGSEL =   5;
    AdcRegs.ADCSOC15CTL.bit.TRIGSEL =   5;


/************************** 5. ADCж **************************/
    // INTSEL1N2ĴADCж1ADCINT1Ĵʹ
    AdcRegs.INTSEL1N2.bit.INT1CONT  = 0;    // ADCINT1Ϊ"δ"ģʽEOC151Σ
    AdcRegs.INTSEL1N2.bit.INT1SEL   = 14;   // ADCINT1"EOC15"15SOCת¼
    // עÿSOCתɶжϣɽINT1SELΪĿSOCEOCSOC1ӦEOC1
    AdcRegs.ADCCTL1.bit.INTPULSEPOS = 1;    // ж"ת浽Ĵ"ȷȶ
    AdcRegs.INTSEL1N2.bit.INT1E     = 1;    // ʹADCINT1ж

    DELAY_US(1000L);  // ȴADCģڲȶʼת
    EDIS;             // ˳"ܱĴģʽ"


/************************** 6. ӳжϵPIECPU **************************/
    PieCtrlRegs.PIEIER1.bit.INTx1 = 1;  // ʹPIE1ĵ1жϣӦADCINT1INT1.1
    IER |= M_INT1;                      // ʹCPUж1PIE1ж
}

//============================================================================
// * Function    :  Get_battery_volt()
// * Purpose     :  Read battery voltage.
// * Parameters  :  Null
// * Return      :  Battery voltageMV
//============================================================================
float Get_battery_volt(void)
{
    float Volt;//صѹ
    Volt=(float)(ADC_Bat*3.0*600.0/4096); //ѹԭͼ򵥷Եõ
    return Volt;
}
//============================================================================
// End of file.
//============================================================================
