//##############################################################################
// *  Bsp_Can.h
// *
// *  Created on: 2025912
// *      Author: С
//##############################################################################
#ifndef _BSP_CAN_H_
#define _BSP_CAN_H_
//==============================================================================
// *  Global Defines for system level initialization
//==============================================================================
#define cCanRxBufSize       10

#define   TXCanId0_Std    0x0101
#define   TXCanId1_Std    0x0102
#define   RXCanId0_Std    0x0201
#define   RXCanId1_Std    0x0202

//==============================================================================
// *  Global Variables for system level initialization
//==============================================================================
typedef union
{
    Uint32  all;
    struct
    {
        Uint16      RES:4;
        Uint16      SrcAddr:6;
        Uint16      DstAddr:6;      // 10:15
        Uint16      NodeRole:2;     // 16:17
        Uint16      PTP:1;          // 18
        Uint16      CabinetAddr:4;  // 19:22
        Uint16      NodeType:4;     // 23:26
        Uint16      Priority:2;     // 27:28
        Uint16      AAM:1;          // 29
        Uint16      AME:1;          // 30
        Uint16      IDE:1;          // 31
    }Bits;
}CANID;

typedef struct
{
    CANID   CanId;
    int16  CanData0;
    int16  CanData1;
    int16  CanData2;
    int16  CanData3;
}CANFRAME;


extern CANFRAME CAN_TxBuf;
extern CANFRAME CAN_RxBuf;
//==============================================================================
// *  Global functions for system level initialization
//==============================================================================

extern void InitCana(void);
extern void Can_Task(void);

extern void sCanHdRead(const Uint8 ubMailBox,CANFRAME *pdata);
extern void sCanHdSend(const Uint8 ubMailBox,const CANFRAME *pdata);

//==============================================================================
// No more.
//==============================================================================
#endif /* _BSP_CAN_H_ */
