/******************************************************************************
 *    FILENAME : Bsp_ECap.c
 *
 *    PURPOSE  : ӿں
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/
#include "User_Include.h"
#include "Bsp_ECap.h"
//============================================================================
// *  Variables & Function_Defines
//============================================================================
Uint32 echo_width = 0;
float  UR_distance=0.0;
//============================================================================
// * Function    :  InitECap1
// * Purpose     :  Initializes the ECap1 register parameters.
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
void InitECap1(void)
{
    //--- 1. ʹeCAP1ʱ ---
    EALLOW;
    SysCtrlRegs.PCLKCR1.bit.ECAP1ENCLK = 1;  // eCAP1
    EDIS;

    //--- 2. UTGPIO ---
    EALLOW;
    // UT_Trig ʼ
    GpioCtrlRegs.GPBPUD.bit.GPIO39 = 0;    // ʹ
    GpioCtrlRegs.GPBDIR.bit.GPIO39 = 1;    // ģʽ
    GpioCtrlRegs.GPBMUX1.bit.GPIO39 = 0;   // ͨGPIO
    // UT_Echo ʼ
    GpioCtrlRegs.GPADIR.bit.GPIO19 = 1;    // ģʽ
    GpioCtrlRegs.GPAPUD.bit.GPIO19 = 0;    // ʹ
    GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 3;   // ѡeCAP1ܣMUX=3
    EDIS;

    //--- 3. eCAPĴ ---
    EALLOW;
   ECap1Regs.ECCTL1.bit.CAPLDEN  = 0;     // ֹװ
   ECap1Regs.ECCTL1.bit.PRESCALE = 0;     // Ƶϵ=160MHzֱӼ
   ECap1Regs.ECCTL2.bit.CAP_APWM = 0;     // ģʽPWM
   ECap1Regs.ECCTL2.bit.CONT_ONESHT = 0;  // βģʽ
   ECap1Regs.ECCTL2.bit.SYNCO_SEL = 0;    // ͬź
   ECap1Regs.ECCTL2.bit.TSCTRSTOP = 1;    // ʹʱ
   ECap1Regs.ECCTL1.bit.CAPLDEN = 1;      // ʹܲװ
    EDIS;

    //--- 4. ò¼+½أ ---
    EALLOW;
   ECap1Regs.ECCTL1.bit.CAP1POL = 0;      // CAP1ش
   ECap1Regs.ECCTL1.bit.CTRRST1 = 1;      // CAP1¼λ
   ECap1Regs.ECCTL1.bit.CAP2POL = 1;      // CAP2½ش
   ECap1Regs.ECCTL1.bit.CTRRST2 = 1;      // CAP2¼λ
    EDIS;

    //--- 5. жϱ־жϣѡ ---
    EALLOW;
   ECap1Regs.ECCLR.bit.CEVT1 = 1;
   ECap1Regs.ECCLR.bit.CEVT2 = 1;
   ECap1Regs.ECEINT.bit.CEVT1 = 1;       // ʹCAP1ж
   ECap1Regs.ECEINT.bit.CEVT2 = 1;       // ʹCAP2ж
    EDIS;

    //--- 6. PIEжע ---
    EALLOW;
    PieVectTable.ECAP1_INT = &ECAP1_INT_ISR;// עISR
    PieCtrlRegs.PIEIER4.bit.INTx1 = 1;    // ʹeCAP1ж
    EDIS;

    //--- 7. ȫжʹ ---
    IER |= M_INT4;   // ʹCPU INT4
    EINT;            // ȫж

}


//============================================================================
// * Function    :  Send_Trig_Pulse()
// * Purpose     :  һ10usĳ
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
void Send_Trig_Pulse(void)
{
    UT_Trig_H;
    DELAY_US(10);
    UT_Trig_L;
}
//============================================================================
// * Function    :  Get_Distance()
// * Purpose     :  㳬
// * Parameters  :  Null
// * Return      :  distance_cm
//============================================================================
float Get_Distance(void)
{
    float distance_mm = 0.0;

    Send_Trig_Pulse();
//    My_DelayMs(1);
    // 루60MHzʱӣ340m/s
    distance_mm = (echo_width * (1.0/60.0)) * 0.343 / 2.0;

    return distance_mm;
}
// -----------------------------------------------------------
// INT_ISR for ECAP-1:
// -----------------------------------------------------------
// INT 4.1
interrupt void ECAP1_INT_ISR(void)    // ECAP-1
{
    // Insert ISR Code here
    if (ECap1Regs.ECFLG.bit.CEVT1 == 1)
    {
       ECap1Regs.ECCLR.bit.CEVT1 = 1;   // жϱ־
    }
    if(ECap1Regs.ECFLG.bit.CEVT2 == 1)
    {
       echo_width =ECap1Regs.CAP2;
       ECap1Regs.ECCLR.bit.CEVT2 = 1;  // жϱ־
    }

   ECap1Regs.ECCLR.all = 0xFFFF;// ж
   PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;  // ȷPIE4ж

}
//============================================================================
// End of file.
//============================================================================
