/******************************************************************************
 *    FILENAME : Bsp_Encoder.c
 *
 *    PURPOSE  : Ӧúӿ
 *
 *     Author: С                      Created on: 2025912
******************************************************************************/
#include "User_Include.h"
#include "Bsp_Encoder.h"

//============================================================================
// *  Variables & Function_Defines
//============================================================================
int16 Encoder_Left_Cnt,Encoder_Right_Cnt;
int16 Encoder_Left,Encoder_Right;
float Velocity_Left,Velocity_Right;        //ٶ(mm/s)
//============================================================================
// * Function    :  InitEncoder
// * Purpose     :  Initialize the resource ports required for the encoder.
// * Parameters  :  Null
// * Return      :  Null
//============================================================================

void InitEncoder(void)
{
    //--- 1. GPIO ---
    EALLOW;
    // Encoder_XINT1A ʼ
    GpioCtrlRegs.GPADIR.bit.GPIO15=0;    // Ϊģʽ
    GpioCtrlRegs.GPAPUD.bit.GPIO15=0;    // 
    GpioCtrlRegs.GPAMUX1.bit.GPIO15=0;
    GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = 0;    // ⲿж1XINT1ϵͳʱSYSCLKOUTͬ

    // Encoder_XINT1B ʼ
    GpioCtrlRegs.GPADIR.bit.GPIO24=0;    // Ϊģʽ
    GpioCtrlRegs.GPAPUD.bit.GPIO24=0;    // 
    GpioCtrlRegs.GPAMUX2.bit.GPIO24 = 0; // ͨIOģʽ

    // Encoder_XINT2A ʼ
    GpioCtrlRegs.GPADIR.bit.GPIO13=0;    // Ϊģʽ
    GpioCtrlRegs.GPAPUD.bit.GPIO13=0;    // 
    GpioCtrlRegs.GPAMUX1.bit.GPIO13=0;
    GpioCtrlRegs.GPAQSEL1.bit.GPIO13 = 0;    // ⲿж2XINT2ϵͳʱSYSCLKOUTͬ

    // Encoder_XINT2B ʼ
    GpioCtrlRegs.GPBDIR.bit.GPIO32=0;    // Ϊģʽ
    GpioCtrlRegs.GPBPUD.bit.GPIO32=0;    // 
    GpioCtrlRegs.GPBMUX1.bit.GPIO32 = 0; // ͨIOģʽ

    EDIS;

    //--- 2. Դ ---
    EALLOW;
    GpioIntRegs.GPIOXINT1SEL.bit.GPIOSEL = 15;   // XINT1GPIO15
    GpioIntRegs.GPIOXINT2SEL.bit.GPIOSEL = 13;   // XINT2GPIO13
    EDIS;

    //--- 3. ģʽ ---
    XIntruptRegs.XINT1CR.bit.POLARITY = 1;      // شж
    XIntruptRegs.XINT1CR.bit.ENABLE= 1;         // ʹXINT1
    XIntruptRegs.XINT2CR.bit.POLARITY = 1;      // شж
    XIntruptRegs.XINT2CR.bit.ENABLE= 1;         // ʹXINT2

    //--- 4. ж ---
    EALLOW;
    PieVectTable.XINT1 = &XINT1_ISR;       // עISR
    PieCtrlRegs.PIEIER1.bit.INTx4 = 1;     // ʹPIE1INT4
    PieVectTable.XINT2 = &XINT2_ISR;       // עISR
    PieCtrlRegs.PIEIER1.bit.INTx5 = 1;     // ʹPIE1INT5
    EDIS;


    //--- 5. ȫжʹ ---
    IER |= M_INT1;                         // ʹCPUж1
    EINT;                                  // ȫж

}


//============================================================================
// * Function    :  Read_Encoder()
// * Purpose     :  Read encoder count per unit time.
// * Parameters  :  TIMX->External interrupt number
// * Return      :  Encoder_Cnt
//============================================================================
int Read_Encoder(Uint8 TIMX)
{
   int16 Encoder_Cnt;
   switch(TIMX)
     {
        case Left:   Encoder_Cnt= Encoder_Left_Cnt;  Encoder_Left_Cnt= 0;break;
        case Right:  Encoder_Cnt= Encoder_Right_Cnt; Encoder_Right_Cnt=0;break;
        default:     Encoder_Cnt= 0;
     }
        return Encoder_Cnt;
}
//============================================================================
//*   : Get_Velocity_Form_Encoder
//* ˵: תΪٶȣmm/s
//*     : encoder_leftֱencoder_rightֱ
//*   ֵ: 
//============================================================================
void Get_Velocity_Form_Encoder(int encoder_left,int encoder_right)
{
    float Rotation_Speed_L,Rotation_Speed_R;                //ת  ת=10msÿΣ*ȡƵ/Ƶ/ٱ/
    Rotation_Speed_L = encoder_left*Control_Frequency/EncoderMultiples/Reduction_Ratio/Encoder_precision;
    Velocity_Left = Rotation_Speed_L*PI*Diameter_67;        //ٶ=ת*ܳ
    Rotation_Speed_R = encoder_right*Control_Frequency/EncoderMultiples/Reduction_Ratio/Encoder_precision;
    Velocity_Right = Rotation_Speed_R*PI*Diameter_67;       //ٶ=ת*ܳ
}
//---------------------------------------------------------------------------
// INT_ISR for XINT1:
//---------------------------------------------------------------------------
// INT1.4
interrupt void  XINT1_ISR(void)
{
    // Insert ISR Code here
    if (XINT1B()== 1)
    {
        Encoder_Left_Cnt++;
    }
    else
    {
        Encoder_Left_Cnt--;
    }
    PieCtrlRegs.PIEACK.bit.ACK1=1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;  // ȷPIE1ж
}

//---------------------------------------------------------------------------
// INT_ISR for XINT2:
//---------------------------------------------------------------------------
// INT1.5
__interrupt void  XINT2_ISR(void)
{
    // Insert ISR Code here
    if (XINT2B() == 1)
      {
        Encoder_Right_Cnt--;
      }
      else
      {
          Encoder_Right_Cnt++;
      }
    PieCtrlRegs.PIEACK.bit.ACK1=1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;  // ȷPIE1ж
}

//============================================================================
// End of file.
//============================================================================

