/******************************************************************************
 *    FILENAME : Bsp_Laser.c
 *
 *    PURPOSE  : LaserӦúӿ
 *
 *    Author: С                      Created on: 2025912
******************************************************************************/
#include "User_Include.h"
#include "Bsp_Laser.h"
//============================================================================
// *  Variables & Function_Defines
//============================================================================ 
Uint8   Laser_Result=0;
//============================================================================
// * Function    :  Laser_Init()
// * Purpose     :
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
void Laser_Init(void)
{			
    EALLOW;  // Ĵд

	// LASER_TX1 ʼ
    GpioCtrlRegs.GPAMUX1.bit.GPIO11=0;    //IO
    GpioCtrlRegs.GPADIR.bit.GPIO11=1;     //˿
    GpioCtrlRegs.GPAPUD.bit.GPIO11=1;     //

	// LASER_TX2 ʼ
    GpioCtrlRegs.GPAMUX1.bit.GPIO5=0;    //IO
    GpioCtrlRegs.GPADIR.bit.GPIO5=1;     //˿
    GpioCtrlRegs.GPAPUD.bit.GPIO5=1;     //

	// LASER_TX3 ʼ
    GpioCtrlRegs.GPAMUX1.bit.GPIO4=0;    //IO
    GpioCtrlRegs.GPADIR.bit.GPIO4=1;     //˿
    GpioCtrlRegs.GPAPUD.bit.GPIO4=1;     //

	// LASER_TX4 ʼ
    GpioCtrlRegs.GPBMUX1.bit.GPIO34=0;    //IO
    GpioCtrlRegs.GPBDIR.bit.GPIO34=1;     //˿
    GpioCtrlRegs.GPBPUD.bit.GPIO34=1;     //

	// LASER_RX1 ʼ
    GpioCtrlRegs.GPAMUX1.bit.GPIO10=0;    //IO
    GpioCtrlRegs.GPADIR.bit.GPIO10=0;     //˿
    GpioCtrlRegs.GPAPUD.bit.GPIO10=1;     //

	// LASER_RX2 ʼ
    GpioCtrlRegs.GPBMUX1.bit.GPIO40=0;    //IO
    GpioCtrlRegs.GPBDIR.bit.GPIO40=0;     //˿
    GpioCtrlRegs.GPBPUD.bit.GPIO40=1;     //

    EDIS;   // ָĴ
}
//============================================================================
// * Function    :  Laser_Scan()
// * Purpose     :
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
Uint8 Laser_Scan(void)
{
    Uint8 i;
    Uint8 Laser_Temp=0;
	for (i = 0; i < 8; i++)
	{
		switch(i)
		{
	    case 0:  LASER_TX1_L;LASER_TX2_L;LASER_TX3_L;LASER_TX4_H;break;  //1
		case 1:  LASER_TX1_H;LASER_TX2_L;LASER_TX3_L;LASER_TX4_H;break;  //2
		case 2:  LASER_TX1_L;LASER_TX2_H;LASER_TX3_L;LASER_TX4_H;break;  //3
		case 3:  LASER_TX1_H;LASER_TX2_H;LASER_TX3_L;LASER_TX4_H;break;  //4
		case 4:  LASER_TX1_L;LASER_TX2_L;LASER_TX3_H;LASER_TX4_H;break;  //5
		case 5:  LASER_TX1_H;LASER_TX2_L;LASER_TX3_H;LASER_TX4_H;break;  //6
		case 6:  LASER_TX1_L;LASER_TX2_H;LASER_TX3_H;LASER_TX4_H;break;  //7
		case 7:  LASER_TX1_H;LASER_TX2_H;LASER_TX3_H;LASER_TX4_H;break;  //8
		default: LASER_TX1_L;LASER_TX2_L;LASER_TX3_L;LASER_TX4_L;break;
		}
		DELAY_US(200);
//	    My_DelayMs(1000);
		if((LASER_RX1())||( LASER_RX2()))    //״̬
		{
			Laser_Temp |= (1<<i);
		}

        LASER_TX1_L;
        LASER_TX2_L;
        LASER_TX3_L;
        LASER_TX4_L;
	}	
	Laser_Test=Laser_Temp;
	switch(Laser_Temp)
		{
        case 0b11111000 :  Laser_Result=Left_L; break;
        case 0b11110001 :  Laser_Result=Left_L; break;
	    case 0b11111110 :  Laser_Result=Left_L; break;
	    case 0b11111100 :  Laser_Result=Left_L; break;
		case 0b11111101 :  Laser_Result=Left_L; break;
	    case 0b11111001 :  Laser_Result=Left_S; break;
	    case 0b11111011 :  Laser_Result=Left_S; break;
		case 0b11110011 :  Laser_Result=Left_S; break;
	    case 0b11110111 :  Laser_Result=Middle; break;
	    case 0b11100111 :  Laser_Result=Middle; break;
		case 0b11101111 :  Laser_Result=Middle; break;
	    case 0b11001111 :  Laser_Result=Right_S;break;
	    case 0b11011111 :  Laser_Result=Right_S;break;
		case 0b10011111 :  Laser_Result=Right_S;break;
		case 0b10111111 :  Laser_Result=Right_L;break;
		case 0b00111111 :  Laser_Result=Right_L;break;
		case 0b01111111 :  Laser_Result=Right_L;break;
        case 0b10001111 :  Laser_Result=Right_L;break;
        case 0b00011111 :  Laser_Result=Right_L;break;
		default:     Laser_Result=Middle; break;   
		}	
	return Laser_Result;  
	}
//============================================================================
// End of file.
//============================================================================
