//##############################################################################
// * Bsp_Library.h
// *
// *  Created on: 2025912
// *      Author: С
//##############################################################################
#ifndef _BSP_LIBRARY_H
#define _BSP_LIBRARY_H

//==============================================================================
// *  Includes
//==============================================================================
#include <math.h>
#include <string.h>
#include <stdint.h>

#include "DSP2803x_Device.h"
#include "DSP2803x_Examples.h"
//==============================================================================
// @ Global Defines for system level initialization
//==============================================================================
//-----------------Ͷ-----------------
typedef unsigned char              u8;
typedef unsigned int              u32;

typedef char                       int8_t;
typedef unsigned char              uint8_t;



//typedef char                            int8;
//typedef unsigned char                   Uint8;

#define GET_HBYTE_OF_WORD(WORD)         ((Uint8)((WORD) >> 8))
#define GET_LBYTE_OF_WORD(WORD)         ((Uint8)((WORD) & 0x00FF))

#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#define MIN(a, b) (((a) < (b)) ? (a) : (b))
#define FABS(a)   (((a) >  0)  ? (a) : (-(a)))

//==============================================================================
// @ Global Variables for system level initialization
//==============================================================================


//==============================================================================
// @ Global functions for system level initialization
//==============================================================================

extern int16  Cal_abs(int16 a);
extern void My_DelayMs(Uint16 DelayMs);
extern void delay_ms(Uint16 DelayMs);
extern Uint16 Cal_CRC16(Uint8 *_pBuf, Uint16 _usLen) ;
extern int16 Output_Limit(int16 IN,int16 max,int16 min);
//==============================================================================
// No more.
//==============================================================================
#endif /* _BSP_LIBRARY_H */
