/******************************************************************************
 *    FILENAME : Bsp_LinDriver.c
 *
 *    PURPOSE  : LIN Initialization & Support Functions.
 *
 *       Author: 电笔小新                      Created on: 2025年9月12日
******************************************************************************/

#include "User_Include.h"
#include "Bsp_LinDriver.h"

//---------------------------------------------------------------------------
// LinaWrite:
//---------------------------------------------------------------------------
Uint16 LinaWrite(Uint8 *pBuf, Uint16 u16Length)
{
    Uint16 i;
    SciStruct       *pSci;

    pSci = pSciIndex[1];
    if(pSci->u8TxStatus == SCI_TX_BUSY)
    {
        return SCI_TX_BUSY;
    }

    pSci->u16TxLength = u16Length;
    pSci->u8TxStatus = SCI_TX_BUSY;
    for(i = 0;i < u16Length;i++)
    {
        while(0 == LinaRegs.SCIFLR.bit.TXRDY)
        {
        }
        LinaRegs.SCITD = *(pBuf + i);
    }
    pSci->u8TxStatus = SCI_TX_RDY;

    return SCI_TX_RDY;
}

//---------------------------------------------------------------------------
//LIN-SCI-->>Init_GPIO
//GPIO22---TX;  GPIO23--RX
//---------------------------------------------------------------------------

void Init_LinaGpio(void)
{
   EALLOW;

    GpioCtrlRegs.GPAPUD.bit.GPIO22 = 0;     // Enable pull-up for GPIO22 (LIN TX)
    GpioCtrlRegs.GPAPUD.bit.GPIO23 = 0;     // Enable pull-up for GPIO23 (LIN RX)

    GpioCtrlRegs.GPAQSEL2.bit.GPIO23 = 3;  // Asynch input GPIO23 (LINRXA)

    GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 3;   // Configure GPIO19 for LIN TX operation  (3-Enable,0-Disable)
    GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 3;   // Configure GPIO23 for LIN RX operation (3-Enable,0-Disable)

    EDIS;
}

//---------------------------------------------------------------------------
// InitLina:
//---------------------------------------------------------------------------
// This function initializes the SCI/BLIN module to SCI.
//
void InitLina(void)
{

    Init_LinaGpio();

    EALLOW;
    //Reset module and release reset.
    LinaRegs.SCIGCR0.bit.RESET = 0;     //Into reset(婢跺秳缍�)
    DELAY_US(50);
    LinaRegs.SCIGCR0.bit.RESET = 1;     //Out of reset閿涘牆鍙ф径宥勭秴閿涳拷

    //SCI into software reset mode
    LinaRegs.SCIGCR1.bit.SWnRST = 0;    //Into software reset閿涘湢IN 閸戝棗顦總鏂ょ礆

    //Select SCI Mode
    LinaRegs.SCIGCR1.bit.LINMODE = 0;       // LIN mode is disabled; SCI compability mode is enabled.

    //Configure SCI mode
    LinaRegs.SCIGCR1.bit.CLK_MASTER = 1;    // Enable clock to the SCI module
    LinaRegs.SCIGCR1.bit.COMMMODE   = 0;    // Idle-line mode is used
    LinaRegs.SCIGCR1.bit.TIMINGMODE = 1;    // SCI timing mode bit.
    LinaRegs.SCIGCR1.bit.PARITYENA  = 0;    // Parity disabled.
    LinaRegs.SCIGCR1.bit.PARITY     = 0;    // unused
    LinaRegs.SCIGCR1.bit.STOP       = 0;    // one stop bit used.
    LinaRegs.SCIGCR1.bit.SLEEP      = 0;    // Disable sleep mode
    LinaRegs.SCIGCR1.bit.MBUFMODE   = 0;    // Disable multi-buffer mode
    LinaRegs.SCIGCR1.bit.LOOPBACK   = 0;    // Disable loopback selfchecking

    LinaRegs.SCIGCR1.bit.CONT       = 1;    //Continue on Suspend
    LinaRegs.SCIGCR1.bit.RXENA      = 1;    // Enable RX pin
    LinaRegs.SCIGCR1.bit.TXENA      = 1;    // Enable TX pin

    //IODFT Configuarations
    LinaRegs.IODFTCTRL.bit.IODFTENA = 0;    // IODFT testing module disabled
    LinaRegs.IODFTCTRL.bit.LPBENA   = 0;    // IODFT loopback disabled

    //SCI Character Size and Length
    LinaRegs.SCIFORMAT.bit.CHAR     = 7;    // the character is 8 bits long
    LinaRegs.SCIFORMAT.bit.LENGTH   = 0;    // Frame lenth is 1 byte

    LinaRegs.BRSR.bit.SCI_LIN_PSH   = 0;
    //Baud Rate Settings - 60MHz device
    //   194-->9600bps ;  97--> 19200bps
    LinaRegs.BRSR.bit.SCI_LIN_PSL   = 194;
    LinaRegs.BRSR.bit.M             = 5;

    //Set all interrupts to disabled
    LinaRegs.SCICLEARINT.all        = 0xFFFFFFFF;
    LinaRegs.SCISETINT.bit.SETRXINT = 1;            // Enable RX interrupt
    LinaRegs.SCICLEARINTLVL.all     = 0xFFFFFFFF;   // Set Int level of all interrupts to LVL 0

    //Release   SCI from software reset state - End of Config
    LinaRegs.SCIGCR1.bit.SWnRST = 1;

    PieCtrlRegs.PIEIER9.bit.INTx3 = 1;      // Enable INT 9.3 in the PIE, LIN0_INTA is INT9.3
    //PieCtrlRegs.PIEIER9.bit.INTx4=1;      // PIE Group 9, INT4
    IER |= M_INT9;                          // Enable CPU Interrupt 9

    EDIS;

    SetSci(ID_LINA, pSciBuf, LINA_BUF_SIZE);
}


//===========================================================================
// End of file.
//===========================================================================


