/******************************************************************************
 *    FILENAME : Bsp_SciDriver.c
 *
 *    PURPOSE  : SCI Initialization & Support Functions.
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/

#include "User_Include.h"
#include "Bsp_SciDriver.h"

//---------------------------------------------------------------------------
// SciWrite:
//---------------------------------------------------------------------------
Uint16 SciWrite(Uint16 SciId, Uint8 *pBuf, Uint16 u16Length)
{
    Uint16 i;
    SciStruct       *pSci;

    pSci = pSciIndex[SciId];
    if(pSci->u8TxStatus == SCI_TX_BUSY)
    {
        return SCI_TX_BUSY;
    }

    pSci->u16TxLength = u16Length;
    pSci->u8TxStatus = SCI_TX_BUSY;
    for(i = 0;i < u16Length;i++)
    {
    while(SciaRegs.SCIFFTX.bit.TXFFST != 0)
        {
        }
        SciaRegs.SCITXBUF = *(pBuf + i);
    }

    pSci->u8TxStatus = SCI_TX_RDY;

    return SCI_TX_RDY;
}
//---------------------------------------------------------------------------
//SCI-->>Init_GPIO
// GPIO28--RX; GPIO29---TX
//---------------------------------------------------------------------------

void InitSciaGpio()
{
   EALLOW;

/* Enable internal pull-up for the selected pins */
// Pull-ups can be enabled or disabled disabled by the user.
// This will enable the pullups for the specified pins.

    GpioCtrlRegs.GPAPUD.bit.GPIO28 = 0;    // Enable pull-up for GPIO28 (SCIRXDA)
//  GpioCtrlRegs.GPAPUD.bit.GPIO7 = 0;     // Enable pull-up for GPIO7  (SCIRXDA)

    GpioCtrlRegs.GPAPUD.bit.GPIO29 = 0;    // Enable pull-up for GPIO29 (SCITXDA)
//  GpioCtrlRegs.GPAPUD.bit.GPIO12 = 0;    // Enable pull-up for GPIO12 (SCITXDA)

/* Set qualification for selected pins to asynch only */
// Inputs are synchronized to SYSCLKOUT by default.
// This will select asynch (no qualification) for the selected pins.

    GpioCtrlRegs.GPAQSEL2.bit.GPIO28 = 3;  // Asynch input GPIO28 (SCIRXDA)
//  GpioCtrlRegs.GPAQSEL1.bit.GPIO7 = 3;   // Asynch input GPIO7 (SCIRXDA)

/* Configure SCI-A pins using GPIO regs*/
// This specifies which of the possible GPIO pins will be SCI functional pins.

    GpioCtrlRegs.GPAMUX2.bit.GPIO28 = 1;   // Configure GPIO28 for SCIRXDA operation
//  GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 2;    // Configure GPIO7  for SCIRXDA operation

    GpioCtrlRegs.GPAMUX2.bit.GPIO29 = 1;   // Configure GPIO29 for SCITXDA operation
//  GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 2;   // Configure GPIO12 for SCITXDA operation

    EDIS;
}

//---------------------------------------------------------------------------
// InitSci:
//---------------------------------------------------------------------------
// This function initializes the SCI(s) to a known state.
//
void InitSci(void)
{
    // Initialize SCI-A:
    InitSciaGpio();

    EALLOW;
   // SCI into software reset mode
    SciaRegs.SCICCR.all = 0x0007;           // 1 stop bit, No loopback, No parity, async mode,
                                            // idle-line protocol, 8 char bits,
    SciaRegs.SCICTL1.all = 0x0003;          // RX_err_INT disable, sleepMode disable, RX/TX enable
                                            // Disable RX ERR, SLEEP, TXWAKE
    SciaRegs.SCICTL2.bit.TXINTENA = 1;      // 0 = disable, 1 = enable TXRDY INT, in FIFO, this INT used as FIFO_Int
    SciaRegs.SCICTL2.bit.RXBKINTENA = 1;    // 1 = enable RXrdy/BRKINT, 0 = disable
    SciaRegs.SCIFFTX.all = 0xE040;
    SciaRegs.SCIFFCT.all = 0x00;
    SciaRegs.SCICTL1.all = 0x0023;          // Relinquish SCI from Reset, by software reset
    SciaRegs.SCIFFTX.bit.TXFIFOXRESET = 1;  // enable TX
    SciaRegs.SCIFFRX.bit.RXFIFORESET = 1;   // enable RX
    SciaRegs.SCIPRI.bit.FREE = 1;

    SciaRegs.SCIHBAUD = 0x00;
    SciaRegs.SCILBAUD = 0xC2;

    SciaRegs.SCIFFRX.all = 0x6061;
    PieCtrlRegs.PIEIER9.bit.INTx1 = 1;      // Enable SCIA_RXINT in PIE group 9
    IER |= M_INT9;

    EDIS;

    SetSci(ID_SCIA, pSciBuf, SCIA_BUF_SIZE);
}

//===========================================================================
// End of file.
//===========================================================================



