/******************************************************************************
 *    FILENAME : bsp_i2c.c
 *
 *    PURPOSE  : IICӦúӿ
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/ 
#include "bsp_i2c.h"   
#include "User_Include.h"
//============================================================================
// *  Variables & Function_Defines
//============================================================================

//============================================================================
//*   : i2c_Delay
//* ˵: I2Cλӳ٣400KHz
//*     : 
//*   ֵ: 
//============================================================================
static void i2c_Delay(void)
{
/*
    ʱͨAX-Pro߼ǲԵõġ

    DELAY_US(1)SCLƵ = 205KHz SCLߵƽʱ1.4usSCL͵ƽʱ3.3us
    DELAY_US(2)SCLƵ = 125KHz SCLߵƽʱ2.5usSCL͵ƽʱ5.5us
    DELAY_US(5)SCLƵ = 60KHz  SCLߵƽʱ5.4usSCL͵ƽʱ11.3us
*/
      DELAY_US(1);
}
//============================================================================
// * Function    :  IIC_Init()
// * Purpose     :  IIC pin initialization.
// * Parameters  :   Null
// * Return      :   Null
//============================================================================
void IIC_Init(void)
{
    EALLOW;
    //ʼ->I2C_SCL
    GpioCtrlRegs.GPAMUX2.bit.GPIO20=0;    //IO
    GpioCtrlRegs.GPADIR.bit.GPIO20=1;     //˿
    GpioCtrlRegs.GPAPUD.bit.GPIO20=1;     //

    //ʼ->I2C_SDA
    GpioCtrlRegs.GPAMUX2.bit.GPIO21=0;    //IO
    GpioCtrlRegs.GPADIR.bit.GPIO21=1;     //˿
    GpioCtrlRegs.GPAPUD.bit.GPIO21=1;     //
    EDIS;

}

//============================================================================
// * Function    :  IIC_Start()
// * Purpose     :  Simulate IIC start signal.
// * Parameters  :   Null
// * Return      :   0->Fail,1->Success
//============================================================================
int IIC_Start(void)
{
    SDA_OUT();     //sda
    I2C_SDA_H;
    if(!SDA_Read())return 0;
    I2C_SCL_H;
    i2c_Delay();
    I2C_SDA_L; //START:when CLK is high,DATA change form high to low
    if(SDA_Read())return 0;
    i2c_Delay();
    I2C_SCL_L;//ǯסI2Cߣ׼ͻ
    return 1;
}


//============================================================================
// * Function    :  IIC_Stop()
// * Purpose     :  Simulate IIC end signal.
// * Parameters  :   Null
// * Return      :   Null
//============================================================================
void IIC_Stop(void)
{
    SDA_OUT();//sda
    I2C_SCL_L;
    I2C_SDA_L;//STOP:when CLK is high DATA change form low to high
    i2c_Delay();
    I2C_SCL_H;
    I2C_SDA_H;//I2C߽ź
    i2c_Delay();
}

//============================================================================
// * Function    :  IIC_Wait_Ack()
// * Purpose     :  IIC wait the response signal
// * Parameters  :  Null
// * Return      :  0->No response received1->Response received
//============================================================================
int IIC_Wait_Ack(void)
{
    u8 ucErrTime=0;
    SDA_IN();      //SDAΪ
    I2C_SDA_H;
    i2c_Delay();
    I2C_SCL_H;
    i2c_Delay();
    while(SDA_Read())
    {
        ucErrTime++;
        if(ucErrTime>50)
        {
            IIC_Stop();
            return 0;
        }
      i2c_Delay();
    }
    I2C_SCL_L;  //ʱ0
    return 1;
} 

//============================================================================
// * Function    :  IIC_Ack()
// * Purpose     :  IIC response.
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
void IIC_Ack(void)
{
    I2C_SCL_L;
    SDA_OUT();
    I2C_SDA_L;
    i2c_Delay();
    I2C_SCL_H;
    i2c_Delay();
    I2C_SCL_L;
}

//============================================================================
// * Function    :  IIC_NAck()
// * Purpose     :  IIC don't reply.
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
void IIC_NAck(void)
{
    I2C_SCL_L;
    SDA_OUT();
    I2C_SDA_H;
    i2c_Delay();
    I2C_SCL_H;
    i2c_Delay();
    I2C_SCL_L;
}
  
//============================================================================
// * Function    :  IIC_Send_Byte()
// * Purpose     :  IIC sends a byte.
// * Parameters  :  txd->Byte data sent
// * Return      :  Null
//============================================================================
void IIC_Send_Byte(u8 txd)
{                        
    u8 t;   
    SDA_OUT();
    I2C_SCL_L;//ʱӿʼݴ
    for(t=0;t<8;t++)
    {              
        if((txd&0x80)>>7)
            I2C_SDA_H;
        else
            I2C_SDA_L;
            txd<<=1;
            i2c_Delay();
            I2C_SCL_H;
            i2c_Delay();
            I2C_SCL_L;
            i2c_Delay();
    }
}
  
//============================================================================
// * Function    :  i2cWrite()
// * Purpose     :  IIC write data to register.
// * Parameters  :  addr->Device addressreg->Register address
// *                len->Number of bytesdata->Data;
// * Return      :  0->Write successfully1->Failed to write
//============================================================================
int i2cWrite(u8 addr, u8 reg, u8 len, u8 *data)
{
        int i;
    if (!IIC_Start())
        return 1;
    IIC_Send_Byte(addr << 1 );
    if (!IIC_Wait_Ack()) {
        IIC_Stop();
        return 1;
    }
    IIC_Send_Byte(reg);
    IIC_Wait_Ack();
        for (i = 0; i < len; i++) {
        IIC_Send_Byte(data[i]);
        if (!IIC_Wait_Ack()) {
            IIC_Stop();
            return 0;
        }
    }
    IIC_Stop();
    return 0;
}

//============================================================================
// * Function    :  i2cRead()
// * Purpose     :  IIC read register data.
// * Parameters  :  addr->Device addressreg->Register address
// *                len->Number of bytes*buf->Data read out;
// * Return      :  0->Read successfully1->Read to write
//============================================================================
int i2cRead(u8 addr, u8 reg, u8 len, u8 *buf)
{
    if (!IIC_Start())
        return 1;
    IIC_Send_Byte(addr << 1);
    if (!IIC_Wait_Ack()) {
        IIC_Stop();
        return 1;
    }
    IIC_Send_Byte(reg);
    IIC_Wait_Ack();
    IIC_Start();
    IIC_Send_Byte((addr << 1)+1);
    IIC_Wait_Ack();
    while (len) {
        if (len == 1)
            *buf = IIC_Read_Byte(0);
        else
            *buf = IIC_Read_Byte(1);
        buf++;
        len--;
    }
    IIC_Stop();
    return 0;
}

//============================================================================
// * Function    :  IIC_Read_Byte()
// * Purpose     :  IIC reads a byte.
// * Parameters  :   ack->Send response signal or not
// *                 1=Send0=Do not send
// * Return      :   receive->Data read
//============================================================================
u8 IIC_Read_Byte(u8 ack)
{
    u8 i,receive=0;
    SDA_IN();//SDAΪ
    for(i=0;i<8;i++ )
     {
            I2C_SCL_L;
            i2c_Delay();
            I2C_SCL_H;
            receive<<=1;
            if(SDA_Read())receive++;
            i2c_Delay();
    }
    if (ack)
        IIC_Ack(); //ACK 
    else
        IIC_NAck();//nACK  
    return receive;
}

//============================================================================
// * Function    :  I2C_ReadOneByte()
// * Purpose     :  IIC reads a byte.
// * Parameters  :  I2C_Addr->Device IIC address
// *                addr->Register address
// * Return      :  res->Data read
//============================================================================
u8 I2C_ReadOneByte(u8 I2C_Addr,u8 addr)
{
    u8 res=0;

    IIC_Start();
    IIC_Send_Byte(I2C_Addr);       //д
    res++;
    IIC_Wait_Ack();
    IIC_Send_Byte(addr); res++;  //͵ַ
    IIC_Wait_Ack();
    //IIC_Stop();//һֹͣ
    IIC_Start();
    IIC_Send_Byte(I2C_Addr+1); res++;          //ģʽ
    IIC_Wait_Ack();
    res=IIC_Read_Byte(0);
    IIC_Stop();//һֹͣ

    return res;
}
 
//============================================================================
// * Function    :  IICreadBytes()
// * Purpose     :  IIC continuous reading data.
// * Parameters  :  dev->Target device IIC addressreg->Register address
// *                length->Number of bytes
// *                *data->The pointer where the read data will be stored
// * Return      :  count->Number of bytes read out-1
//============================================================================
u8 IICreadBytes(u8 dev, u8 reg, u8 length, u8 *data)
{
    u8 count = 0;

    IIC_Start();
    IIC_Send_Byte(dev); //д
    IIC_Wait_Ack();
    IIC_Send_Byte(reg);   //͵ַ
    IIC_Wait_Ack();
    IIC_Start();
    IIC_Send_Byte(dev+1);  //ģʽ
    IIC_Wait_Ack();

    for(count=0;count<length;count++){

         if(count!=length-1)   data[count]=IIC_Read_Byte(1);  //ACKĶ
         else                   data[count]=IIC_Read_Byte(0);  //һֽNACK
    }
    IIC_Stop();//һֹͣ
    return count;
}

//============================================================================
// * Function    :  IICwriteBytes()
// * Purpose     :  Writes multiple bytes to the specified register of the specified device.
// * Parameters  :  dev->Target device IIC addressreg->Register address
// *                length->Number of bytes
// *                *data->The pointer where the read data will be stored
// * Return      :  1->Write successfully
//============================================================================
u8 IICwriteBytes(u8 dev, u8 reg, u8 length, u8* data)
{
    u8 count = 0;
    IIC_Start();
    IIC_Send_Byte(dev);    //д
    IIC_Wait_Ack();
    IIC_Send_Byte(reg);   //͵ַ
  IIC_Wait_Ack();
    for(count=0;count<length;count++){
        IIC_Send_Byte(data[count]);
        IIC_Wait_Ack();
     }
    IIC_Stop();//һֹͣ

    return 1; //status == 0;
}

//============================================================================
// * Function    :  IICreadByte()
// * Purpose     :  Reads a byte of the specified register of the specified device.
// * Parameters  :  dev->Target device IIC addressreg->Register address
// *                *data->The pointer where the read data will be stored
// * Return      :  1->Read successfully
//============================================================================
u8 IICreadByte(u8 dev, u8 reg, u8 *data)
{
    *data=I2C_ReadOneByte(dev, reg);
    return 1;
}

//============================================================================
// * Function    :  IICreadByte()
// * Purpose     :  Write a byte to the specified register of the specified device.
// * Parameters  :  dev->Target device IIC addressreg->Register address
// *                data->Data to be writtenwill be stored
// * Return      :  1->Write successfully
//============================================================================
u8 IICwriteByte(u8 dev, u8 reg, u8 data)
{
    return IICwriteBytes(dev, reg, 1, &data);
}

//============================================================================
// * Function    :  IICwriteBits()
// * Purpose     :  Read,modify,and write multiple bits in a byte of the specified device specified register.
// * Parameters  :  dev->Target device IIC addressreg->Register addresslength->Number of bytes
// *                bitStart->Start bit of target byte
// *                data->Stores the value of the target byte bit to be changed
// * Return      :  1->Write success0->Write fail
//============================================================================
u8 IICwriteBits(u8 dev,u8 reg,u8 bitStart,u8 length,u8 data)
{

    u8 b;
    if (IICreadByte(dev, reg, &b) != 0) {
        u8 mask = (0xFF << (bitStart + 1)) | 0xFF >> ((8 - bitStart) + length - 1);
        data <<= (8 - length);
        data >>= (7 - bitStart);
        b &= mask;
        b |= data;
        return IICwriteByte(dev, reg, b);
    } else {
        return 0;
    }
}

//============================================================================
// * Function    :  IICwriteBit()
// * Purpose     :  Read,modify,and write multiple bits in a byte of the specified device specified register.
// * Parameters  :  dev->Target device IIC addressreg->Register addresslength->Number of bytes
// *                bitStart->Start bit of target byte
// *                data->Stores the value of the target byte bit to be changed
// * Return      :  1->Write success0->Write fail
//============================================================================
u8 IICwriteBit(u8 dev, u8 reg, u8 bitNum, u8 data)
{
    u8 b;
    IICreadByte(dev, reg, &b);
    b = (data != 0) ? (b | (1 << bitNum)) : (b & ~(1 << bitNum));
    return IICwriteByte(dev, reg, b);
}

//============================================================================
// End of file.
//============================================================================
