//##############################################################################
// *  bsp_i2c.h
// *
// *  Created on: 2025912
// *      Author: С
//##############################################################################
#ifndef _BSP_I2C_H
#define _BSP_I2C_H

//==============================================================================
// *  Includes
//==============================================================================
#include "Bsp_Library.h"

//==============================================================================
// *  Global Defines for system level initialization
//==============================================================================
// I2C_SCL GPIO ź궨
#define I2C_SCL_H      (GpioDataRegs.GPASET.bit.GPIO20=1)       /* SCL = 1 */
#define I2C_SCL_L      (GpioDataRegs.GPACLEAR.bit.GPIO20=1)     /* SCL = 0 */

// I2C_SDA GPIO ź궨
#define I2C_SDA_H      (GpioDataRegs.GPASET.bit.GPIO21=1)       /* SDA = 1 */
#define I2C_SDA_L      (GpioDataRegs.GPACLEAR.bit.GPIO21=1)     /* SDA = 0 */

//I2C_SDA IO
#define SDA_IN()      {EALLOW; GpioCtrlRegs.GPADIR.bit.GPIO21=0; EDIS;}       //Input. SDA
#define SDA_OUT()     {EALLOW; GpioCtrlRegs.GPADIR.bit.GPIO21=1; EDIS;}       //Output. SDA
#define SDA_Read()    (GpioDataRegs.GPADAT.bit.GPIO21)          /* SDA״̬ */


//==============================================================================
// *  Global Variables for system level initialization
//==============================================================================


//==============================================================================
// *  Global functions for system level initialization
//==============================================================================
void IIC_Init(void);                //ʼIICIO

int  IIC_Start(void);              //IICʼź
void IIC_Stop(void);               //IICֹͣź
void IIC_Send_Byte(u8 txd);        //IICһֽ
u8   IIC_Read_Byte(u8 ack);        //IICȡһֽ
int  IIC_Wait_Ack(void);           //IICȴACKź

void IIC_Ack(void);                //IICACKź
void IIC_NAck(void);               //IICACKź

void IIC_Write_One_Byte(u8 daddr,u8 addr,u8 data);
u8 IIC_Read_One_Byte(u8 daddr,u8 addr);
u8 I2C_Readkey(u8 I2C_Addr);

u8 I2C_ReadOneByte(u8 I2C_Addr,u8 addr);
u8 IICwriteByte(u8 dev, u8 reg, u8 data);
u8 IICwriteBytes(u8 dev, u8 reg, u8 length, u8* data);
u8 IICwriteBits(u8 dev,u8 reg,u8 bitStart,u8 length,u8 data);
u8 IICwriteBit(u8 dev,u8 reg,u8 bitNum,u8 data);
u8 IICreadBytes(u8 dev, u8 reg, u8 length, u8 *data);

int i2cWrite(u8 addr, u8 reg, u8 len, u8 *data);
int i2cRead(u8 addr, u8 reg, u8 len, u8 *buf);

//==============================================================================
// No more.
//==============================================================================
#endif /* _BSP_I2C_H */
