/******************************************************************************
 *    FILENAME : bsp_mpu6050.c
 *
 *    PURPOSE  : MPU6050Ӧúӿ
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/ 
#include "bsp_i2c.h"
#include "bsp_mpu6050.h"  
#include "User_Include.h"

//============================================================================
// *  Variables & Function_Defines
//============================================================================
#define PRINT_ACCEL     (0x01)
#define PRINT_GYRO      (0x02)
#define PRINT_QUAT      (0x04)
#define ACCEL_ON        (0x01)
#define GYRO_ON         (0x02)
#define MOTION          (0)
#define NO_MOTION       (1)
#define DEFAULT_MPU_HZ  (200)
#define FLASH_SIZE      (512)
#define FLASH_MEM_START ((void*)0x1800)
#define q30  1073741824.0f


uint8_t buffer[14];

int16_t  MPU6050_FIFO[6][11];
int16_t Gx_offset=0,Gy_offset=0,Gz_offset=0;



/**************************************************************************
Function: The new ADC data is updated to FIFO array for filtering
Input   : axayazxy, z-axis acceleration datagxgygzx. Y, z-axis angular acceleration data
Output  : none
ܣµADCݸµ FIFO飬˲
ڲaxayazxyzٶݣgxgygzxyzǼٶ
  ֵ
**************************************************************************/
void  MPU6050_newValues(int16_t ax,int16_t ay,int16_t az,int16_t gx,int16_t gy,int16_t gz)
{
unsigned char i ;
int32_t sum=0;
for(i=1;i<10;i++){  //FIFO 
MPU6050_FIFO[0][i-1]=MPU6050_FIFO[0][i];
MPU6050_FIFO[1][i-1]=MPU6050_FIFO[1][i];
MPU6050_FIFO[2][i-1]=MPU6050_FIFO[2][i];
MPU6050_FIFO[3][i-1]=MPU6050_FIFO[3][i];
MPU6050_FIFO[4][i-1]=MPU6050_FIFO[4][i];
MPU6050_FIFO[5][i-1]=MPU6050_FIFO[5][i];
}
MPU6050_FIFO[0][9]=ax;//µݷõ ݵ
MPU6050_FIFO[1][9]=ay;
MPU6050_FIFO[2][9]=az;
MPU6050_FIFO[3][9]=gx;
MPU6050_FIFO[4][9]=gy;
MPU6050_FIFO[5][9]=gz;

sum=0;
for(i=0;i<10;i++){  //ǰĺϣȡƽֵ
   sum+=MPU6050_FIFO[0][i];
}
MPU6050_FIFO[0][10]=sum/10;

sum=0;
for(i=0;i<10;i++){
   sum+=MPU6050_FIFO[1][i];
}
MPU6050_FIFO[1][10]=sum/10;

sum=0;
for(i=0;i<10;i++){
   sum+=MPU6050_FIFO[2][i];
}
MPU6050_FIFO[2][10]=sum/10;

sum=0;
for(i=0;i<10;i++){
   sum+=MPU6050_FIFO[3][i];
}
MPU6050_FIFO[3][10]=sum/10;

sum=0;
for(i=0;i<10;i++){
   sum+=MPU6050_FIFO[4][i];
}
MPU6050_FIFO[4][10]=sum/10;

sum=0;
for(i=0;i<10;i++){
   sum+=MPU6050_FIFO[5][i];
}
MPU6050_FIFO[5][10]=sum/10;
}

/**************************************************************************
Function: Setting the clock source of mpu6050
Input   : sourceClock source number
Output  : none
ܣ  MPU6050 ʱԴ
ڲsourceʱԴ
  ֵ
 * CLK_SEL | Clock Source
 * --------+--------------------------------------
 * 0       | Internal oscillator
 * 1       | PLL with X Gyro reference
 * 2       | PLL with Y Gyro reference
 * 3       | PLL with Z Gyro reference
 * 4       | PLL with external 32.768kHz reference
 * 5       | PLL with external 19.2MHz reference
 * 6       | Reserved
 * 7       | Stops the clock and keeps the timing generator in reset
**************************************************************************/
void MPU6050_setClockSource(uint8_t source){
    IICwriteBits(devAddr, MPU6050_RA_PWR_MGMT_1, MPU6050_PWR1_CLKSEL_BIT, MPU6050_PWR1_CLKSEL_LENGTH, source);

}

/** Set full-scale gyroscope range.
 * @param range New full-scale gyroscope range value
 * @see getFullScaleRange()
 * @see MPU6050_GYRO_FS_250
 * @see MPU6050_RA_GYRO_CONFIG
 * @see MPU6050_GCONFIG_FS_SEL_BIT
 * @see MPU6050_GCONFIG_FS_SEL_LENGTH
 */
void MPU6050_setFullScaleGyroRange(uint8_t range) {
    IICwriteBits(devAddr, MPU6050_RA_GYRO_CONFIG, MPU6050_GCONFIG_FS_SEL_BIT, MPU6050_GCONFIG_FS_SEL_LENGTH, range);
}

/**************************************************************************
Function: Setting the maximum range of mpu6050 accelerometer
Input   : rangeAcceleration maximum range number
Output  : none
ܣ MPU6050 ٶȼƵ
ڲrangeٶ̱
  ֵ
**************************************************************************/
//#define MPU6050_ACCEL_FS_2          0x00          //===+-2G
//#define MPU6050_ACCEL_FS_4          0x01          //===+-4G
//#define MPU6050_ACCEL_FS_8          0x02          //===+-8G
//#define MPU6050_ACCEL_FS_16         0x03          //===+-16G
void MPU6050_setFullScaleAccelRange(uint8_t range) {
    IICwriteBits(devAddr, MPU6050_RA_ACCEL_CONFIG, MPU6050_ACONFIG_AFS_SEL_BIT, MPU6050_ACONFIG_AFS_SEL_LENGTH, range);
}

/**************************************************************************
Function: Set mpu6050 to sleep mode or not
Input   : enable1sleep0work
Output  : none
ܣ MPU6050 Ƿ˯ģʽ
ڲenable1˯0
  ֵ
**************************************************************************/
void MPU6050_setSleepEnabled(uint8_t enabled) {
    IICwriteBit(devAddr, MPU6050_RA_PWR_MGMT_1, MPU6050_PWR1_SLEEP_BIT, enabled);
}

/**************************************************************************
Function: Read identity
Input   : none
Output  : 0x68
ܣȡ  MPU6050 WHO_AM_I ʶ
ڲ
  ֵ0x68
**************************************************************************/
uint8_t MPU6050_getDeviceID(void) {

    IICreadBytes(devAddr, MPU6050_RA_WHO_AM_I, 1, buffer);
    return buffer[0];
}

/**************************************************************************
Function: Check whether mpu6050 is connected
Input   : none
Output  : 1Connected0Not connected
ܣMPU6050 ǷѾ
ڲ
  ֵ1ӣ0δ
**************************************************************************/
uint8_t MPU6050_testConnection(void) {
   if(MPU6050_getDeviceID() == 0x68)  //0b01101000;
   return 1;
    else return 0;
}

/**************************************************************************
Function: Setting whether mpu6050 is the host of aux I2C cable
Input   : enable1yes0;not
Output  : none
ܣ MPU6050 ǷΪAUX I2Cߵ
ڲenable1ǣ0
  ֵ
**************************************************************************/
void MPU6050_setI2CMasterModeEnabled(uint8_t enabled) {
    IICwriteBit(devAddr, MPU6050_RA_USER_CTRL, MPU6050_USERCTRL_I2C_MST_EN_BIT, enabled);
}

/**************************************************************************
Function: Setting whether mpu6050 is the host of aux I2C cable
Input   : enable1yes0;not
Output  : none
ܣ MPU6050 ǷΪAUX I2Cߵ
ڲenable1ǣ0
  ֵ
**************************************************************************/
void MPU6050_setI2CBypassEnabled(uint8_t enabled) {
    IICwriteBit(devAddr, MPU6050_RA_INT_PIN_CFG, MPU6050_INTCFG_I2C_BYPASS_EN_BIT, enabled);
}

/**************************************************************************
Function: initialization Mpu6050 to enter the available state
Input   : none
Output  : none
ܣʼ    MPU6050 Խ״̬
ڲ
  ֵ
**************************************************************************/
void MPU6050_initialize(void) 
    {
    MPU6050_setClockSource(MPU6050_CLOCK_PLL_YGYRO); //ʱ
    MPU6050_setFullScaleGyroRange(MPU6050_GYRO_FS_2000);//
    MPU6050_setFullScaleAccelRange(MPU6050_ACCEL_FS_2); //ٶȶ +-2G
    MPU6050_setSleepEnabled(0); //빤״̬
    MPU6050_setI2CMasterModeEnabled(0);  //MPU6050 AUXI2C
    MPU6050_setI2CBypassEnabled(0);  //I2C    MPU6050AUXI2C  ֱͨر
}


/**************************************************************************
Function: Read mpu6050 built-in temperature sensor data
Input   : none
Output  : Centigrade temperature
ܣȡMPU6050¶ȴ
ڲ
  ֵ¶
**************************************************************************/
int Read_Temperature(void)
{
      float Temp;
      Temp=(I2C_ReadOneByte(devAddr,MPU6050_RA_TEMP_OUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_TEMP_OUT_L);
        if(Temp>32768) Temp-=65536; //ת
        Temp=(36.53+Temp/340)*10;     //¶ȷŴʮ
      return (int)Temp;
}
//============================================================================
// End of file.
//============================================================================
