/******************************************************************************
 *    FILENAME : User_IPMOS.c
 *
 *    PURPOSE  : Interface of software oscilloscope
 *
 *       Author: 电笔小新                      Created on: 2025年9月12日
******************************************************************************/
#include "User_Include.h"
#include "User_IPMOS.h"

//=============================================================================
// *  Variables & Function_Defines
//=============================================================================

Uint8   wScopeSelect=10;
int16   uwScope[30];

typedef int (*pFunc1)(void);

extern Uint16 LinaWrite( Uint8 *pBuf, Uint16 u16Length);
extern Uint16 SciWrite(Uint16 SciId, Uint8 *pBuf, Uint16 u16Length);
/******************************variable definition******************************/

Uint16  u16IPOMS_GraphDataBuff[4][400];
Uint16  u16IPOMS_TransmitDataBuff[500];

Uint16  u16IPOMS_CommandLength  = 0;
Uint16  u16IPOMS_Interval       = 0;
Uint16  u16IPOMS_Interval1      = 0;
Uint16  u16IPOMS_SnatchDataCnt  = 0;
Uint16  u16IPOMS_SaveDataCnt    = 0;
Uint16  u16IPOMS_TransmitCnt    = 0;
Uint16  u16IPOMS_CompareVal     = 0;
Uint8   *pIPOMS_CommandIn0;

Uint8   u8IPOMS_UserDataBuf0[80];
Uint8   u8IPOMS_CommandBuffer0[50];
Uint8   u8IPOMS_RxBuffer0[50];

Uint8   u8IPOMS_DataKind[4]     = {0,0,0,0};
Uint8   u8IPOMS_SnatchGraphEnable= 1;
Uint8   u8IPOMS_SendHighHalfByte = 1;
Uint8   u8IPOMS_wTriggerSource  = 0;
Uint8   u8IPOMS_wTrigger        = 0;
Uint8   u8IPOMS_HighByte        = 0;
Uint8   u8IPOMS_LowByte         = 0;
Uint8   u8IPOMS_Sign            = 0;

Uint16 wTriggerWaiting = 0;


/******************************function list******************************/
Uint8 IPOMS_SnatchGraph(void);
void  IPOMS_SCI(void);
Uint8  IPOMS_Write(Uint16 SciId, Uint8 *pBuf, Uint16 u16Length);

void FlashProgramming(void);
void  IPOMS_Parsing(void);


void  IPOMS_Q1Command(void);
void  IPOMS_Q2Command(void);
void  IPOMS_Q3Command(void);
void  IPOMS_QDCommand(void);

int16 IPOMS_GraphicView_0(void);
int16 IPOMS_GraphicView_1(void);
int16 IPOMS_GraphicView_2(void);
int16 IPOMS_GraphicView_3(void);
int16 IPOMS_GraphicView_4(void);
int16 IPOMS_GraphicView_5(void);
int16 IPOMS_GraphicView_6(void);
int16 IPOMS_GraphicView_7(void);
int16 IPOMS_GraphicView_8(void);
int16 IPOMS_GraphicView_9(void);
int16 IPOMS_GraphicView_10(void);
int16 IPOMS_GraphicView_11(void);
int16 IPOMS_GraphicView_12(void);
int16 IPOMS_GraphicView_13(void);
int16 IPOMS_GraphicView_14(void);
int16 IPOMS_GraphicView_15(void);

Uint8 sbNumToAscii(Uint16 u16Number, int8 i8Exponent, Uint8 *pbBuffer);
void IPOMS_WriteBinary(Uint16 *pstart, Uint16 u16Length);


/******************************function list******************************/
pFunc1 GetDataSubArray[] =
{

 IPOMS_GraphicView_0,  // Note: Don't set "Channel x ID" to 0 in "Graphic View"
                       // in IPOMS. 0 is invalid.

 IPOMS_GraphicView_1,  // 1- is the number set to "Channelx ID"
 IPOMS_GraphicView_2,
 IPOMS_GraphicView_3,
 IPOMS_GraphicView_4,
 IPOMS_GraphicView_5,
 IPOMS_GraphicView_6,
 IPOMS_GraphicView_7,
 IPOMS_GraphicView_8,
 IPOMS_GraphicView_9,
 IPOMS_GraphicView_10,
 IPOMS_GraphicView_11,
 IPOMS_GraphicView_12,
 IPOMS_GraphicView_13,
 IPOMS_GraphicView_14,
 IPOMS_GraphicView_15,
};


//=============================================================================
// *  FUNCTION:  IPOMS_Write()
// *
// *  PURPOSE :  Use IPOMS to Write data.
//=============================================================================
Uint8 IPOMS_Write(Uint16 SciId, Uint8 *pBuf, Uint16 u16Length)
{
    Uint8 u8IPOMS_temp;
    switch(SciId)
        {
            case ID_SCIA:
                 u8IPOMS_temp=SciWrite(ID_SCIA, pBuf,u16Length);
            break;

            case ID_LINA:
                 u8IPOMS_temp=LinaWrite(pBuf,u16Length);
            break;

            default:
                u8IPOMS_temp=1;
               break;
        }

        return u8IPOMS_temp;
}


//=============================================================================
// *  FUNCTION:  SCI_IPOMS()
// *
// *  PURPOSE :  Software OSC for debug.
//=============================================================================
void IPOMS_SCI(void)
{
    Uint8 u8IPOMS_temp;
    while(1)
    {
        u8IPOMS_temp = SciRead(ID_IPOMS, pIPOMS_CommandIn0);

        if(SCI_RX_EMPTY == u8IPOMS_temp)
        {
            break;
        }
        if(u16IPOMS_CommandLength >= con_MAX_COMMAND_LENGTH)
        {
            pIPOMS_CommandIn0 = u8IPOMS_CommandBuffer0;
            u16IPOMS_CommandLength = 0;
        }
        else if(0xDD == (*pIPOMS_CommandIn0))
        {
            FlashProgramming();
            pIPOMS_CommandIn0 = u8IPOMS_CommandBuffer0;
            u16IPOMS_CommandLength = 0;
        }
        else if((con_CHAR_ENTER == (*pIPOMS_CommandIn0)) || (0x0A == (*pIPOMS_CommandIn0)))  //Deal with command with 0x0a
        {
            IPOMS_Parsing();
            pIPOMS_CommandIn0 = u8IPOMS_CommandBuffer0;
            u16IPOMS_CommandLength = 0;
        }
        else
        {
            u16IPOMS_CommandLength++;
            pIPOMS_CommandIn0++;
        }
    }
}

//=============================================================================
// *  FUNCTION:  FlashProgramming()
// *
// *  PURPOSE :  Online update User Code.
//=============================================================================
void FlashProgramming(void)
{
    if((u8IPOMS_CommandBuffer0[1] == 0x1A)&(u8IPOMS_CommandBuffer0[2] == 0x2A))
    {
/*------------------------------------------------------------------
   Disable CPU interrupts and clear all CPU interrupt flags.
------------------------------------------------------------------*/
        DINT;
        DRTM;
        IER = 0x0000;
        IFR = 0x0000;

/*------------------------------------------------------------------
 Jump to BootLoader.
------------------------------------------------------------------*/
        asm("  LB  0x3F7FF6");
    }

}

/*=============================================================================*
 * FUNCTION: IPOMS_Parsing(void)
 * PURPOSE : IPOMS Command Parse
 * INPUT:
 *     void
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *     IPOMS_Q1Command();
 *     IPOMS_Q3Command();
 *     IPOMS_QDCommand();
 *
 * CALLED BY:
 *     TSK_F_IPOMS()
 *
 *============================================================================*/
void IPOMS_Parsing(void)
{

    switch(u8IPOMS_CommandBuffer0[0])
    {
    case 'Q':
        {

            if('1' == u8IPOMS_CommandBuffer0[1])
            {
                IPOMS_Q1Command();
            }
             if('2' == u8IPOMS_CommandBuffer0[1])
            {
                IPOMS_Q2Command();
            }
            if('3' == u8IPOMS_CommandBuffer0[1])
            {
                IPOMS_Q3Command();
            }
            if('D' == u8IPOMS_CommandBuffer0[1])
            {
                IPOMS_QDCommand();
            }
            if('4' == u8IPOMS_CommandBuffer0[1])
            {
                B_Kp++;
            }
            if('5' == u8IPOMS_CommandBuffer0[1])
            {
                B_Kp--;
            }
            if('6' == u8IPOMS_CommandBuffer0[1])
            {
                B_Kd++;
            }
            if('7' == u8IPOMS_CommandBuffer0[1])
            {
                B_Kd--;
            }
            if('8' == u8IPOMS_CommandBuffer0[1])
            {
                V_Kp++;
            }
            if('9' == u8IPOMS_CommandBuffer0[1])
            {
                V_Kp--;
            }
            if('L' == u8IPOMS_CommandBuffer0[1])
            {
                Flag_Left=1;
            }
            if('R' == u8IPOMS_CommandBuffer0[1])
            {
                Flag_Right=1;
            }
            if('F' == u8IPOMS_CommandBuffer0[1])
            {
                Flag_front=1;
            }
            if('B' == u8IPOMS_CommandBuffer0[1])
            {
                Flag_back=1;
            }
        }
    break;
    default:
    break;
    }
}
/*=============================================================================*
 * FUNCTION: IPOMS_Q1Command(void)
 * PURPOSE : Send Data to IPOMS For Q1 Command
 * INPUT:
 *     void  // TRUE:disable the dog锟斤拷FALSE:enable the dog
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *     //sbNumToAscii();
 *     //IPOMS_Write();
 *
 *
 *
 * CALLED BY:
 *   //  INT32 IPOMS_Parsing()
 *
 *============================================================================*/
    void IPOMS_Q1Command(void)
    {
        Uint8   bStrLen;
        Uint8   bStrLen1;
        Uint8   *pDataBuf;

        bStrLen1 = 0;
        bStrLen = 0;

        bStrLen = sbNumToAscii(0, 0, u8IPOMS_UserDataBuf0);//0
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[1], 0, pDataBuf); //1//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[2], 0, pDataBuf); //2//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[3], 0, pDataBuf);  //3//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[4], 0, pDataBuf);  //4//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[5], 0, pDataBuf);  //5//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[6], 0, pDataBuf);  //6//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[7], 0, pDataBuf);  //7//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[8], 0, pDataBuf);  //8//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[9], 0, pDataBuf);  //9//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[10], 0, pDataBuf);    //10//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[11], 0, pDataBuf);    //11//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;


        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[12], 0, pDataBuf);    //12//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(uwScope[13], 0, pDataBuf);    //13//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(14, 0, pDataBuf);    //14//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(15, 0, pDataBuf);    //15//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(16, 0, pDataBuf);  //16//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(17, 0, pDataBuf);  //17//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(18, 0, pDataBuf);  //18//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
        bStrLen1 = sbNumToAscii(19, 0, pDataBuf);  //19//
        bStrLen += bStrLen1;
        u8IPOMS_UserDataBuf0[bStrLen++] = 32;

        IPOMS_Write(ID_IPOMS, u8IPOMS_UserDataBuf0, bStrLen);
    }

void IPOMS_Q2Command(void)
{
    Uint8   bStrLen;
    Uint8   bStrLen1;
    Uint8   *pDataBuf;

    bStrLen1 = 0;
    bStrLen = 0;

    bStrLen = sbNumToAscii(0, 0, u8IPOMS_UserDataBuf0);//0
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[1], 0, pDataBuf); //1//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[2] , 0, pDataBuf); //2//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[3], 0, pDataBuf);  //3//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[4], 0, pDataBuf);  //4//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[5], 0, pDataBuf);  //5//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[6], 0, pDataBuf);  //6//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[7], 0, pDataBuf);  //7//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[8], 0, pDataBuf);  //8//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[9], 0, pDataBuf);  //9//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[10], 0, pDataBuf);  //10//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[11], 0, pDataBuf);  //11//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;


    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[12], 0, pDataBuf);  //12//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[13], 0, pDataBuf);  //13//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[14], 0, pDataBuf);  //14//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(uwScope[15], 0, pDataBuf);  //15//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(0, 0, pDataBuf);  //16//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(0, 0, pDataBuf);  //17//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(0, 0, pDataBuf);  //18//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    pDataBuf = &u8IPOMS_UserDataBuf0[bStrLen];
    bStrLen1 = sbNumToAscii(0, 0, pDataBuf);  //19//
    bStrLen += bStrLen1;
    u8IPOMS_UserDataBuf0[bStrLen++] = 32;

    IPOMS_Write(ID_IPOMS, u8IPOMS_UserDataBuf0, bStrLen);

}

/*=============================================================================*
 * FUNCTION: IPOMS_Q3Command(void)
 * PURPOSE : Pick up parameter for Snatch Graph fuction
 * INPUT:
 *     void  // TRUE:disable the dog锟斤拷FALSE:enable the dog
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *    //IPOMS_Write

 * CALLED BY:
 * //    INT32 IPOMS_Parsing()
 *
 *============================================================================*/
void IPOMS_Q3Command(void)
{
    Uint16 u16SnatchDataCntTemp, u16IntervalTemp;
    Uint8 u8DataKindTemp1, u8DataKindTemp2, u8DataKindTemp3, u8DataKindTemp4;
    Uint8 u8TriggerSourceTemp, u8TriggerTemp, u8SignTemp;
    Uint16 i, u16LengthTemp, u16CompareValTemp;

    u16LengthTemp = u16IPOMS_CommandLength;

    for(i = 0;i < u16LengthTemp;i++)
    {
        u8IPOMS_UserDataBuf0[i] = u8IPOMS_CommandBuffer0[i];
    }

      IPOMS_Write(ID_IPOMS, u8IPOMS_UserDataBuf0, u16LengthTemp);

    //aaa
    u16SnatchDataCntTemp = (u8IPOMS_CommandBuffer0[2] - 48) * 100 + (u8IPOMS_CommandBuffer0[3] - 48) * 10 + u8IPOMS_CommandBuffer0[4] - 48;
    //bbb
    u16IntervalTemp = (u8IPOMS_CommandBuffer0[6] - 48) * 100 + (u8IPOMS_CommandBuffer0[7] - 48) * 10 + u8IPOMS_CommandBuffer0[8] - 48;
    //cc
    u8DataKindTemp1 = (u8IPOMS_CommandBuffer0[10] - 48) * 10 + u8IPOMS_CommandBuffer0[11] - 48;
    //dd
    u8DataKindTemp2 = (u8IPOMS_CommandBuffer0[13] - 48) * 10 + u8IPOMS_CommandBuffer0[14] - 48;
    //ee
    u8DataKindTemp3 = (u8IPOMS_CommandBuffer0[16] - 48) * 10 + u8IPOMS_CommandBuffer0[17] - 48;
    //ff
    u8DataKindTemp4 = (u8IPOMS_CommandBuffer0[19] - 48) * 10 + u8IPOMS_CommandBuffer0[20] - 48;
    //gg
    u8TriggerSourceTemp = (u8IPOMS_CommandBuffer0[22] - 48) * 10 + u8IPOMS_CommandBuffer0[23] - 48;
    //h
    u8TriggerTemp = u8IPOMS_CommandBuffer0[25] - 48;
    //+/-
    u8SignTemp = u8IPOMS_CommandBuffer0[27] - 48;
    //iiiii
    u16CompareValTemp = (u8IPOMS_CommandBuffer0[29] - 48) * 10000 + (u8IPOMS_CommandBuffer0[30] - 48) * 1000 \
     + (u8IPOMS_CommandBuffer0[31] - 48) * 100 + (u8IPOMS_CommandBuffer0[32] - 48) * 10 + u8IPOMS_CommandBuffer0[33] - 48;

    if((u16SnatchDataCntTemp > 500) ||(u16IntervalTemp > 500) ||(u8TriggerTemp > 4))
    {
        return;
    }

    u16IPOMS_SaveDataCnt = 0;
    u16IPOMS_SnatchDataCnt = u16SnatchDataCntTemp;
    u16IPOMS_Interval = u16IntervalTemp;
    u16IPOMS_Interval1 = u16IPOMS_Interval;

    u8IPOMS_DataKind[0] = u8DataKindTemp1;
    u8IPOMS_DataKind[1] = u8DataKindTemp2;
    u8IPOMS_DataKind[2] = u8DataKindTemp3;
    u8IPOMS_DataKind[3] = u8DataKindTemp4;
    u8IPOMS_wTriggerSource = u8TriggerSourceTemp;
    u8IPOMS_wTrigger = u8TriggerTemp;
    u8IPOMS_Sign = u8SignTemp;

    u16IPOMS_CompareVal = u16CompareValTemp;
    u16IPOMS_TransmitCnt = 0;

    if ((u8IPOMS_wTriggerSource != 0) && (u8IPOMS_wTrigger != 0))
    {
        wTriggerWaiting = 1;
    }
    else
    {
        wTriggerWaiting=0;
    }
}
/*=============================================================================*
 * FUNCTION:  IPOMS_QDCommand(void)
 * PURPOSE :  Send Data to IPOMS For QD Command
 * INPUT:
 *     void  // TRUE:disable the dog 锟斤拷 FALSE:enable the dog
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *      //IPOMS_WriteBinary()
 *
 *
 * CALLED BY:
 *     //INT32 IPOMS_Parsing()
 *
 *============================================================================*/
void IPOMS_QDCommand(void)
{
    Uint8 u8Temp;
    int16 i;
    int32 i32CheckSum;

    u8Temp = u8IPOMS_CommandBuffer0[2] - 48;

    if((u8Temp >=4 ) || (0 == u16IPOMS_TransmitCnt))
    {
        return;
    }
    u16IPOMS_TransmitDataBuff[0] = 0x01;        //SOH
    u16IPOMS_TransmitDataBuff[1] = u16IPOMS_TransmitCnt;    //length

    i32CheckSum =(int32)(0x01 + u16IPOMS_TransmitCnt);
    for(i = 0;i < u16IPOMS_TransmitCnt;i++)
    {
        u16IPOMS_TransmitDataBuff[2 + i] = u16IPOMS_GraphDataBuff[u8Temp][i];
        i32CheckSum += u16IPOMS_GraphDataBuff[u8Temp][i];
    }

    u16IPOMS_TransmitDataBuff[2 + u16IPOMS_TransmitCnt] = (Uint16)(i32CheckSum & 0x0000FFFF);

    IPOMS_WriteBinary(u16IPOMS_TransmitDataBuff, u16IPOMS_TransmitCnt + 3);

}
/*=============================================================================*
 * FUNCTION:  IPOMS_SnatchGraph(void)
 * PURPOSE :  SnatchGraph Data in the switching interrupt
 * INPUT:
 *     void  // TRUE:disable the dog 锟斤拷 FALSE:enable the dog
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *
 * CALLED BY:
 *     //INT32 IPOMS_QDCommand()
 *
 *============================================================================*/
Uint8 IPOMS_SnatchGraph(void)
{
    int16 i,j;

    //trigger condition check
    if(0 == u8IPOMS_SnatchGraphEnable)
    {
      return(false);
    }

    if(0 == u8IPOMS_wTrigger)
    {
      return(false);
    }

    if( wTriggerWaiting==1 )
    {
        if (u8IPOMS_wTrigger==2 )
        {
            if (GetDataSubArray[u8IPOMS_wTriggerSource]()<((int)u16IPOMS_CompareVal) )
            {
                wTriggerWaiting=0;
            }
            /*if (u8IPOMS_Sign=='+')
            {
                if (GetDataSubArray[u8IPOMS_wTriggerSource]()<((int)u16IPOMS_CompareVal) )
                {
                    wTriggerWaiting=0;
                }
            }
            else if ( u8IPOMS_Sign=='-')
            {
                if (GetDataSubArray[u8IPOMS_wTriggerSource]() < -((int)u16IPOMS_CompareVal) )
                {
                    wTriggerWaiting=0;
                }
            }*/
        }
        else if (u8IPOMS_wTrigger == 3)
        {
            if (GetDataSubArray[u8IPOMS_wTriggerSource]() > ((int)u16IPOMS_CompareVal))
            {
                wTriggerWaiting = 0;
            }
        }
        else if (u8IPOMS_wTrigger == 4)
        {
            if (GetDataSubArray[u8IPOMS_wTriggerSource]() == ((int)u16IPOMS_CompareVal))
            {
                wTriggerWaiting=0;
            }
        }
        return(false);
    }

    if(u16IPOMS_Interval1 > 0)
    {
        if(0 == (--u16IPOMS_Interval1))
        {
            u16IPOMS_Interval1 = u16IPOMS_Interval;
        }
        else
        {
            return(false);
        }
    }

 /*   for(i = 0;i < 2;i++)//两通道
    {
        j=u8IPOMS_DataKind[i];
        if(0 == j)
        {
            continue;
        }
        u16IPOMS_GraphDataBuff[i][u16IPOMS_SaveDataCnt] = (Uint16)GetDataSubArray[j]();
    }*/
   for(i = 0;i < 4;i++)   //四通道
    {
        j=u8IPOMS_DataKind[i];
        if(0 == j)
        {
            continue;
        }
        u16IPOMS_GraphDataBuff[i][u16IPOMS_SaveDataCnt] = (Uint16)GetDataSubArray[j]();
    }

    ++u16IPOMS_SaveDataCnt;
    if(u16IPOMS_SaveDataCnt == u16IPOMS_SnatchDataCnt)
    {
        u16IPOMS_TransmitCnt = u16IPOMS_SnatchDataCnt;
        u16IPOMS_SnatchDataCnt = 0;
        u16IPOMS_SaveDataCnt = 0;
        u8IPOMS_wTrigger = 0;
        u8IPOMS_wTriggerSource = 0;
        u8IPOMS_SnatchGraphEnable = 1;
        return(true);
    }

    return(false);
}

//=============================================================================
// *  FUNCTION:  IPOMS_GraphicView_x()
// *
// *  PURPOSE :  Assign variable shown in Graphic View screen of IPOMS.
//=============================================================================

int16 IPOMS_GraphicView_0(void)
{
    return(uwScope[0]);
}
int16 IPOMS_GraphicView_1(void)
{
    return(uwScope[1]);
}
int16 IPOMS_GraphicView_2(void)
{
    return(uwScope[2]);
}
int16 IPOMS_GraphicView_3(void)
{
    return(uwScope[3]);
}

int16 IPOMS_GraphicView_4(void)
{
    return(uwScope[4]);
}

int16 IPOMS_GraphicView_5(void)
{
    return(uwScope[5]);
}

int16 IPOMS_GraphicView_6(void)

{
    return(uwScope[6]);
}

int16 IPOMS_GraphicView_7(void)
{
    return(uwScope[7]);
}

int16 IPOMS_GraphicView_8(void)
{
    return(uwScope[8]);
}

int16 IPOMS_GraphicView_9(void)
{
    return(uwScope[9]);
}

int16 IPOMS_GraphicView_10(void)
{
    return(uwScope[10]);
}

int16 IPOMS_GraphicView_11(void)
{
    return(uwScope[11]);
}

int16 IPOMS_GraphicView_12(void)
{
    return(uwScope[12]);
}

int16 IPOMS_GraphicView_13(void)
{
    return(uwScope[13]);
}

int16 IPOMS_GraphicView_14(void)
{
    return(uwScope[14]);
}

int16 IPOMS_GraphicView_15(void)
{
    return(uwScope[15]);
}
/*=============================================================================*
 * FUNCTION: sbNumToAscii
 * PURPOSE :  Convert input u16Number into max. 8 digital numbers including
 *            decimal represented byASCII code.
 * INPUT:
 *     void  // TRUE:disable the dog 锟斤拷 FALSE:enable the dog
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *     void
 *
 * CALLED BY:
 *
 * IPOMS_Q1Command
 *
 *============================================================================*/
Uint8 sbNumToAscii(Uint16 u16Number, int8 i8Exponent, Uint8 *pbBuffer)
{
    Uint8 u8No;
    int8 i,j;
    Uint8 bArrayTemp[8] = {0,0,0,0,0,0,0,0};
    Uint32 u32NumberTemp;
    j = 0;

    if((0 == u16Number) || ((u16Number != 0) && (i8Exponent < -6)))
    {
        *pbBuffer = '0';
        u8No = 1;
    }
    else
    {
        u32NumberTemp = (Uint32)u16Number;
        for(i = 0;i < i8Exponent;i++)
        {
            if(u32NumberTemp <= 9999999)
            {
                u32NumberTemp = u32NumberTemp * 10;
            }
            else
            {
                u32NumberTemp = 99999999;
            }
        }
        while ((u32NumberTemp > 0) || (i8Exponent < 0))
        {
            i = u32NumberTemp % 10;
            u32NumberTemp = u32NumberTemp / 10;
            bArrayTemp[j] = i + 0x30;
            j++;

            i8Exponent++;
            if(0 == i8Exponent)
            {
                bArrayTemp[j] = '.';
                j++;
                if(0 == u32NumberTemp)
                {
                    bArrayTemp[j] = '0';
                    j++;
                }
            }
        }
        u8No = 0;
        j--;
        while (j >= 0)
        {
            *(pbBuffer + u8No) = bArrayTemp[j];
            u8No++;
            j--;
        }
    }/* end of number !=0 */
    return(u8No);/* char length*/
}

/*=============================================================================*
 * FUNCTION:  IPOMS_WriteBinary
 * PURPOSE :  Write a 16bit data to  IPOMS Tx Port
 * INPUT:
 *     void  // TRUE:disable the dog 锟斤拷 FALSE:enable the dog
 *
 * RETURN:
 *     void
 *
 * CALLS:
 *    // void sSplit()
 *
 * CALLED BY:
 *     IPOMS_QDCommand()
 *
 *============================================================================*/
void IPOMS_WriteBinary(Uint16 *pstart, Uint16 u16Length)
{
    int8 i;
    int8 j;
    Uint16 *pData;
    Uint8  u8Data;

    u8IPOMS_SendHighHalfByte = 1;
    pData = pstart;
    for(i = 0;i < u16Length;i++)
    {
        //split
        //sSplit(*pData);

        for(j = 0;j < 2;j++)
        {
            if(1 == u8IPOMS_SendHighHalfByte)
            {   //write high 8bit
                u8Data = GET_HBYTE_OF_WORD(*pData);
                while(IPOMS_Write(ID_IPOMS, &u8Data, 1));
                u8IPOMS_SendHighHalfByte = 0;
            }
            else
            {   //write low 8bit
                u8Data = GET_LBYTE_OF_WORD(*pData);
                while(IPOMS_Write(ID_IPOMS, &u8Data, 1));
                u8IPOMS_SendHighHalfByte = 1;
            }
        }

        ++pData;
    }
}

//=============================================================================
// End of file.
//=============================================================================

