//##############################################################################
// * User_Include.h
// *
// *  Created on: 2022822
// *      Author: LRS
//##############################################################################
#ifndef USER_INCLUDE_H_
#define USER_INCLUDE_H_

//==============================================================================
// *  Includes
//==============================================================================

#include <math.h>
#include <string.h>
#include <stdint.h>

#include "DSP2803x_Device.h"
#include "DSP2803x_Examples.h"

#include "Bsp_Library.h"
#include "Bsp_ECap.h"
#include "Bsp_Can.h"
#include "Bsp_Adc.h"
#include "Bsp_LinDriver.h"
#include "Bsp_SciDriver.h"
#include "Bsp_key.h"
#include "bsp_oled.h"
#include "Bsp_Motor.h"
#include "Bsp_Laser.h"
#include "bsp_Encoder.h"

#include "bsp_i2c.h"
#include "bsp_mpu6050.h"



#include "User_Queue.h"
#include "User_IPMOS.h"
#include "User_Show.h"
#include "User_filter.h"

//==============================================================================
// *  Global Defines for system level initialization
//==============================================================================
#define INV_PERIOD      (1500)      //20KHz
#define LLC_PERIOD      (600)       //50KHz
#define FAN_PERIOD      (1200)      //25KHz

//  GPIOܿڶ

#define LED1_OFF        (GpioDataRegs.GPBSET.bit.GPIO41=1)
#define LED1_ON         (GpioDataRegs.GPBCLEAR.bit.GPIO41=1)
#define LED1_TOGGLE     (GpioDataRegs.GPBTOGGLE.bit.GPIO41=1)

#define LED2_OFF        (GpioDataRegs.GPASET.bit.GPIO12=1)
#define LED2_ON         (GpioDataRegs.GPACLEAR.bit.GPIO12=1)
#define LED2_TOGGLE     (GpioDataRegs.GPATOGGLE.bit.GPIO12=1)


#define TEST1_H          (GpioDataRegs.GPASET.bit.GPIO30=1)
#define TEST1_L         (GpioDataRegs.GPACLEAR.bit.GPIO30=1)
#define TEST1_TOGGLE      (GpioDataRegs.GPATOGGLE.bit.GPIO30=1)

#define TEST2_H          (GpioDataRegs.GPASET.bit.GPIO31=1)
#define TEST2_L         (GpioDataRegs.GPACLEAR.bit.GPIO31=1)
#define TEST2_TOGGLE      (GpioDataRegs.GPATOGGLE.bit.GPIO31=1)


//==============================================================================
// *  Global Variables for system level initialization
//==============================================================================

extern int  OLED_Cnt;
extern Uint8  Laser_Test;

extern Uint8 Flag_line,Flag_follow,Flag_avoid;          //Ѳߡ桢ϱ־λ
extern Uint8 Flag_Stop;//ֹͣ־λ
extern Uint8 Flag_Show;//ʾ־λ
extern Uint8 Way_Angle; //ȡǶȵ㷨1Ԫ  2  3˲
extern Uint8 Flag_front,Flag_back,Flag_Left,Flag_Right,Flag_velocity; //ңصı
extern float Balance_Kp,Balance_Kd,Velocity_Kp,Velocity_Ki,Turn_Kp,Turn_Kd;//PIDŴ100

extern float Angle_Balance,Gyro_Balance,Gyro_Turn; //ƽ ƽ ת
extern int Motor_Left,Motor_Right;                  //PWM

extern int  B_Kp,B_Kd,V_Kp,V_Kd;        //λԲ
//==============================================================================
// *  Global functions for system level initialization
//==============================================================================
extern void InitDSPSystem(void);
extern void InitParameter(void);

//==============================================================================
// No more.
//==============================================================================
#endif /* USER_INCLUDE_H_ */
