/******************************************************************************
 *    FILENAME : User_Initialize.c
 *
 *    PURPOSE  :
 *
 *       Author: 电笔小新                      Created on: 2025年9月12日
******************************************************************************/
#include "User_Include.h"

//=============================================================================
// *  Variables & Function_Defines
//=============================================================================

Uint8 Flag_line,Flag_follow,Flag_avoid;          //激光巡线、超声波跟随、超声波壁障标志位
Uint8 Flag_Stop,Flag_Show;             //电机停止标志位和显示标志位
Uint8 Flag_front,Flag_back,Flag_Left,Flag_Right,Flag_velocity; //蓝牙遥控相关的变量
Uint8 Way_Angle; //获取角度的算法，1：卡尔曼  2：互补滤波


//控制环PID参数（放大100倍）
float Balance_Kp,Balance_Kd,Velocity_Kp,Velocity_Ki,Turn_Kp,Turn_Kd;

void InitUserGpio(void);
//=============================================================================
// *  FUNCTION: UserMemCopy()
// *
// *  PURPOSE : Simple memory copy routine to move code out of flash into SARAM.
//=============================================================================
void UserMemCopy(Uint16 *SourceAddr, Uint16* SourceEndAddr, Uint16* DestAddr)
{
    while(SourceAddr < SourceEndAddr)
    {
       *DestAddr++ = *SourceAddr++;
    }
    return;
}
//=============================================================================
// *  FUNCTION: InitialDSP()
// *
// *  PURPOSE : Initializes the DSPsystem register parameters.
//=============================================================================
void InitDSPSystem(void)
{
// Initialize System Control:b
// PLL, WatchDog, enable Peripheral Clocks
   InitSysCtrl();

// Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
   DINT;

// Initialize PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the DSP2803x_PieCtrl.c file.
   InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2803x_DefaultIsr.c.
// This function is found in DSP2803x_PieVect.c.
   InitPieVectTable();

// Copy time critical code and Flash setup code to RAM
   UserMemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);
// 调用FLASH初始化函数来设置flash等待状态
// 这个函数必须在RAM中运行
   InitFlash();
//-----------------------------------以上是系统初始化用的，一般不动----------------------------//

    InitUserGpio();
    InitAdc();
     InitLina();
     OLED_Init();
     KEY_Init();
     InitSci();
//    InitCana();//CAN初始化

     InitECap1();
     Laser_Init();
     Motor_Init();
     InitEncoder();

    IIC_Init();               //初始化IIC的IO口
    MPU6050_initialize();     //MPU6050初始化

    InitCpuTimers();  //调用官方库函数，初始化CPU定时器
//    ConfigCpuTimer(&CpuTimer0, 60, 500000);   //定时器0初始化，第二个参数为CPU SYSCLK = 60M， 第三个参数为设定的周期，us单位
//    CpuTimer0Regs.TCR.bit.TSS = 0;            // To start or restart the CPU-timer, set TSS to 0
//    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;        //Enable TINT0 in the PIE
//    IER |= M_INT1;                            //Enable group_1 interrupt

    ConfigCpuTimer(&CpuTimer1, 60, 10000);//定时器1初始化，第二个参数为CPU SYSCLK = 60M， 第三个参数为设定的周期，us单位
    CpuTimer1Regs.TCR.bit.TSS = 0;// To start or restart the CPU-timer, set TSS to 0
    IER |= M_INT13;      //enable group interrupt

    //中断配置步骤-----5
    PieCtrlRegs.PIECTRL.bit.ENPIE = 1;    // Enable the PIE block
    EINT;                                 // Enable Global interrupt INTM
    ERTM;                                 // Enable Global interrupt DBGM

}

//=============================================================================
// *  FUNCTION: InitUserGpio()
// *
// *  PURPOSE : Initializes the UserGpios.
//=============================================================================
void InitUserGpio(void)
{
    EALLOW;

    // Each GPIO pin can be:
    // a) a GPIO input/output
    // b) peripheral function 1
    // c) peripheral function 2
    // d) peripheral function 3
    // By default, all are GPIO Inputs
    GpioCtrlRegs.GPAMUX1.all = 0x0000;     // GPIO functionality GPIO0-GPIO15
    GpioCtrlRegs.GPAMUX2.all = 0x0000;     // GPIO functionality GPIO16-GPIO31
    GpioCtrlRegs.GPBMUX1.all = 0x0000;     // GPIO functionality GPIO32-GPIO44

    // To avoid input noise, disable AIO functions. AIO are disabled in default.
    //GpioCtrlRegs.AIOMUX1.all = 0x0000;     // Dig.IO funct. applies to AIO2,4,6,10,12,14


//---------------------------------LRS-------------------------------------------//
// LED1 初始化
    GpioCtrlRegs.GPBMUX1.bit.GPIO41=0;    //IO口
    GpioCtrlRegs.GPBDIR.bit.GPIO41=1;     //端口设置输出
    GpioCtrlRegs.GPBPUD.bit.GPIO41=1;     //上拉

// LED2 初始化
    GpioCtrlRegs.GPAMUX1.bit.GPIO12=0;   //IO口
    GpioCtrlRegs.GPADIR.bit.GPIO12=1;    //端口设置输出
    GpioCtrlRegs.GPAPUD.bit.GPIO12=1;    //上拉

// TEST1 初始化
    GpioCtrlRegs.GPAMUX2.bit.GPIO30=0;    //IO口
    GpioCtrlRegs.GPADIR.bit.GPIO30=1;     //端口设置输出
    GpioCtrlRegs.GPAPUD.bit.GPIO30=1;     //上拉

// TEST2 初始化
    GpioCtrlRegs.GPAMUX2.bit.GPIO31=0;    //IO口
    GpioCtrlRegs.GPADIR.bit.GPIO31=1;     //端口设置输出
    GpioCtrlRegs.GPAPUD.bit.GPIO31=1;     //上拉

//---------------------------------LRS-------------------------------------------//

    // Each input can have different qualification
    // a) input synchronized to SYSCLKOUT
    // b) input qualified by a sampling window
    // c) input sent asynchronously (valid for peripheral inputs only)
    GpioCtrlRegs.GPAQSEL1.all = 0x0000;    // GPIO0 -GPIO15 Synch to SYSCLKOUT
    GpioCtrlRegs.GPAQSEL2.all = 0x0000;    // GPIO16-GPIO31 Synch to SYSCLKOUT
    GpioCtrlRegs.GPBQSEL1.all = 0x0000;    // GPIO32-GPIO44 Synch to SYSCLKOUT

    EDIS;
}

//============================================================================
// * Function    :  User_Parameter()
// * Purpose     :  Initializes the Parameter of User;
// * Parameters  :  Null
// * Return      :  Null
//============================================================================
void InitParameter(void)
{
    Flag_Stop=1;      //电机停止标志位
    Flag_line=0;
    Flag_follow=0;
    Flag_avoid=0;
    Flag_velocity=2;  //平衡车运动档位:1->高速档 ,2->低速档
    Way_Angle=2;      //获取角度的算法，1->卡尔曼滤波  2->互补滤波

    Flag_front=0;
    Flag_back=0;
    Flag_Left=0;
    Flag_Right=0;
    Flag_velocity=0;

    Angle_Balance=0.0;
    Gyro_Balance=0.0;
    Gyro_Turn=0.0;


    Balance_Kp=25500;         //直立PID参数（放大100倍）
    Balance_Kd=130;

    Velocity_Kp=16000;       //前进PID参数（放大100倍）
    Velocity_Ki=80;

    Turn_Kp=2000;            //拐弯PID参数（放大100倍）
    Turn_Kd=0;

    Motor_Disable();
}

//=============================================================================
// End of file.
//=============================================================================
