/******************************************************************************
 *    FILENAME : User_Interrupt.c
 *
 *    PURPOSE  :
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/
#include "User_Include.h"

//=============================================================================
// *  Variables & Function_Defines
//=============================================================================
#define Middle_angle -1

Uint16 Temperature=0;
Uint8  Laser_Test=0;
float Angle_Balance,Gyro_Balance,Gyro_Turn;
float Roll,Pitch,Yaw;

float Acceleration_Z;                         //Zٶȼ

int Motor_Left,Motor_Right;                  //PWM
float RC_Velocity,RC_Turn_Velocity,Move_X,Move_Z,PS2_ON_Flag;  //ңؿƵٶ

int  B_Kp=100,B_Kd=70,V_Kp=54,V_Kd=123;     //CF˲ܹȶվԭ,վȶ
//int  B_Kp=100,B_Kd=80,V_Kp=54,V_Kd=123;   //CF˲ܹȶվԭ
//int  B_Kp=100,B_Kd=80,V_Kp=54,V_Kd=114;
//int  B_Kp=100,B_Kd=80,V_Kp=52,V_Kd=82;
//int  B_Kp=100,B_Kd=80,V_Kp=52,V_Kd=100;


//============================================================================
//*   : Get_Angle
//* ˵: ȡǶ
//*     : way->ȡǶȵ㷨 1DMP  2 3˲
//*   ֵ: 
//============================================================================
void Get_Angle(Uint8 way)
{
    float gyro_x,gyro_y;
    float Accel_Y,Accel_Z,Accel_X,Accel_Angle_x,Accel_Angle_y,Gyro_X,Gyro_Z,Gyro_Y;
    Temperature=Read_Temperature();      //ȡMPU6050¶ȴݣƱʾ¶ȡ
    Gyro_X=(I2C_ReadOneByte(devAddr,MPU6050_RA_GYRO_XOUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_GYRO_XOUT_L);    //ȡX
    Gyro_Y=(I2C_ReadOneByte(devAddr,MPU6050_RA_GYRO_YOUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_GYRO_YOUT_L);    //ȡY
    Gyro_Z=(I2C_ReadOneByte(devAddr,MPU6050_RA_GYRO_ZOUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_GYRO_ZOUT_L);    //ȡZ
    Accel_X=(I2C_ReadOneByte(devAddr,MPU6050_RA_ACCEL_XOUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_ACCEL_XOUT_L); //ȡXٶȼ
    Accel_Y=(I2C_ReadOneByte(devAddr,MPU6050_RA_ACCEL_YOUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_ACCEL_YOUT_L); //ȡXٶȼ
    Accel_Z=(I2C_ReadOneByte(devAddr,MPU6050_RA_ACCEL_ZOUT_H)<<8)+I2C_ReadOneByte(devAddr,MPU6050_RA_ACCEL_ZOUT_L); //ȡZٶȼ
    if(Gyro_X>32768)  Gyro_X-=65536;                 //ת  Ҳͨshortǿת
    if(Gyro_Y>32768)  Gyro_Y-=65536;                 //ת  Ҳͨshortǿת
    if(Gyro_Z>32768)  Gyro_Z-=65536;                 //ת
    if(Accel_X>32768) Accel_X-=65536;                //ת
    if(Accel_Y>32768) Accel_Y-=65536;                //ת
    if(Accel_Z>32768) Accel_Z-=65536;                //ת
    Gyro_Balance=-Gyro_X/12.0;                            //ƽٶ
    Accel_Angle_x=atan2(Accel_Y,Accel_Z)*180/PI;     //ǣתλΪ
    Accel_Angle_y=atan2(Accel_X,Accel_Z)*180/PI;     //ǣתλΪ

    gyro_x=Gyro_X/32.8;                              //ת
    gyro_y=Gyro_Y/32.8;                              //ת
    if(Way_Angle==1)
    {

         Pitch = -Kalman_Filter_x(Accel_Angle_x,gyro_x);//˲
         Roll = -Kalman_Filter_y(Accel_Angle_y,gyro_y);
    }
    else if(Way_Angle==2)
    {
         Pitch = -Complementary_Filter_x(Accel_Angle_x,gyro_x);//˲
         Roll = -Complementary_Filter_y(Accel_Angle_y,gyro_y);
    }
    Angle_Balance=Pitch;                              //ƽ
    Gyro_Turn=Gyro_Z;                                 //תٶ
    Acceleration_Z=Accel_Z;                           //Zٶȼ

}
//============================================================================
//*   : Turn_Off
//* ˵: 쳣رյ
//*     : angle->Сǣvoltage->صѹ
//*   ֵ: 1쳣  0
//============================================================================
Uint8 Turn_Off(float angle, int voltage)
{
    Uint8 temp;
    if(angle<-40||angle>40||1==Flag_Stop)              //صѹ10Vرյ
    {                                                    //Ǵ40ȹرյ
        temp=1;                                          //Flag_Stop1ƹرյ
        Motor_Disable();
    }
    else
        temp=0;
    return temp;
}

//============================================================================
//*   : Balance
//* ˵: ֱPD
//*     : Angle->ǶȣGyro->ٶ
//*   ֵ: balance->ֱPWM
//============================================================================
int Balance(float Angle,float Gyro)
{
    float Angle_bias,Gyro_bias;
    int balance;
    Angle_bias=Middle_angle-Angle;                                      //ƽĽǶֵ ͻе
    Gyro_bias=0-Gyro;

    balance=-Balance_Kp/B_Kp*Angle_bias-Gyro_bias*Balance_Kd/B_Kd; //ƽƵĵPWM  PD   kpPϵ kdDϵ
    uwScope[1]=B_Kp;
    uwScope[2]=B_Kd;

    uwScope[8]=Balance_Kp/B_Kp*Angle_bias;
    uwScope[9]=Gyro_bias*Balance_Kd/B_Kd;
    return balance;
}

//============================================================================
//*   : Velocity
//* ˵: ٶȿPWM
//*     : encoder_left->ֱencoder_right->ֱ
//*   ֵ: ٶȿPWM
//============================================================================
//޸ǰٶȣ޸Target_Velocity磬ĳ60ͱȽ
int Velocity(int encoder_left,int encoder_right)
{
    static float velocity,Encoder_Least,Encoder_bias,Movement;
    static float Encoder_Integral,Target_Velocity;
//================ңǰ˲====================//
        if(Flag_line==1||Flag_follow==1||Flag_avoid==1) Target_Velocity = 10; //Ѳ//ģʽ,ٶ
        else                              Target_Velocity = 20;
        if(Flag_front==1)
            {
            Movement=Target_Velocity/Flag_velocity;   //յǰź
            Flag_front=0;
            }
        else if(Flag_back==1)
            {
            Movement=-Target_Velocity/Flag_velocity;  //յź
            Flag_back=0;
            }
      else  Movement=0;

//==================Ѳ=======================//
 if(Flag_line==1&&Flag_front==1&&Flag_Left!=1&&Flag_Right!=1) //Ѳ
           Movement=Target_Velocity/10;
//=============ܣ/ϣ==================//
if(Flag_follow==1&&(UR_distance>200&&UR_distance<500)&&Flag_Left!=1&&Flag_Right!=1) //
    Movement=Target_Velocity/Flag_velocity;
if(Flag_follow==1&&UR_distance<200&&Flag_Left!=1&&Flag_Right!=1)
    Movement=-Target_Velocity/Flag_velocity;

if(Flag_avoid==1&&UR_distance<450&&Flag_Left!=1&&Flag_Right!=1)  //
    Movement=-Target_Velocity/Flag_velocity;

//================ٶPI=====================//
        Encoder_Least =0-(encoder_left+encoder_right);                    //ȡٶƫ=Ŀٶȣ˴Ϊ㣩-ٶȣұ֮ͣ
        Encoder_bias *= 0.84;                                                 //һ׵ͨ˲
        Encoder_bias += Encoder_Least*0.16;                               //һ׵ͨ˲ٶȱ仯
        Encoder_Integral +=Encoder_bias;                                  //ֳλ ʱ䣺10ms
//        Encoder_Integral=Encoder_Integral+Movement+Move_X;                       //ңݣǰ
        Encoder_Integral=Encoder_Integral+Movement;                       //ңݣǰ
        if(Encoder_Integral>2000)      Encoder_Integral=2000;             //޷
        if(Encoder_Integral<-2000)   Encoder_Integral=-2000;            //޷
//        velocity=-Encoder_bias*Velocity_Kp/80.0-Encoder_Integral*Velocity_Ki/80.0;     //ٶȿ
        velocity=-Encoder_bias*Velocity_Kp/V_Kp-Encoder_Integral*Velocity_Ki/V_Kd;     //ٶȿ
        if(Turn_Off(Angle_Balance,Bat_volt)==1||Flag_Stop==1) Encoder_Integral=0;//رպ
        uwScope[3]=V_Kp;
        uwScope[4]=Encoder_Integral;

        uwScope[10]=Encoder_bias*Velocity_Kp/V_Kp;
        uwScope[11]=Encoder_Integral*Velocity_Ki/V_Kd;
      return velocity;
}

//============================================================================
//*   : Turn
//* ˵: ת
//*     : Z
//*   ֵ: תPWM
//============================================================================
int Turn(float gyro)
{
    static Uint8 Flag_Left_Cnt,Flag_Right_Cnt;
    static float Turn_Target,turn,Turn_Amplitude=2000;
//    float Kp=Turn_Kp,Kd;           //޸תٶȣ޸Turn_Amplitude
    //===============================//
      if(Flag_line==1)
      {
          switch(Laser_Result)
          {
          case Left_L  :  Turn_Target = -Turn_Amplitude/2;  break;
          case Left_S  :  Turn_Target = -Turn_Amplitude/4;  break;
          case Middle  :  Turn_Target = 0;   Flag_front=1;  break;
          case Right_S :  Turn_Target = Turn_Amplitude/4;   break;
          case Right_L :  Turn_Target = Turn_Amplitude/2;   break;
          default:        Turn_Target = 0;   Flag_front=0;  break;
          }
      }
    //===================ңת=================//
      else
      {
          if(Flag_Left==1)
                 {
                 Turn_Target=-Turn_Amplitude;
                 Flag_Left_Cnt++;
                 if(Flag_Left_Cnt>10)
                 {
                     Flag_Left=0;
                     Flag_Left_Cnt=0;

                 }
                 }
             else if(Flag_Right==1)
                 {
                 Turn_Target=Turn_Amplitude;
                 Flag_Right_Cnt++;
                      if(Flag_Right_Cnt>10)
                      {
                          Flag_Right=0;
                          Flag_Right_Cnt=0;
                      }
                 }

             else Turn_Target=0;
      }
//    if(1==Flag_front||1==Flag_back)  Kd=Turn_Kd;
//    else Kd=0;   //תʱȡǵľ еģPID˼
////===================תPD=================//
//  turn=Turn_Target*Kp/100+gyro*Kd/100;//ZǽPD
    turn=Turn_Target;
    return turn;                   //תPWMתΪתΪ
}

//============================================================================
//*   : Choose
//* ˵: ѡСģʽ
//*     : encoder_left  encoder_rightұ
//*   ֵ: 
//============================================================================
void Choose(int encoder_left,int encoder_right)
{
    static int count;
    if(Flag_Stop==0)
        count = 0;
    if((Flag_Stop==1)&&(encoder_left<10))   //ʱֲֹͣ
    {
        count += Cal_abs(encoder_right);
        if(count>6&&count<150)      //ͨģʽ
        {
            Flag_line   = 0;
            Flag_follow = 0;
            Flag_avoid  = 0;
        }

        if(count>150&&count<300)    //Ѳģʽ
        {
            Flag_line   = 1;
            Flag_follow = 0;
            Flag_avoid  = 0;
        }
        if(count>300&&count<450)    //ģʽ
        {
            Flag_line   = 0;
            Flag_follow = 1;
            Flag_avoid  = 0;
        }
        if(count>450&&count<600)    //ģʽ
        {
            Flag_line   = 0;
            Flag_follow = 0;
            Flag_avoid  = 1;
        }
        if(count>600)
            count = 0;
    }
}


//============================================================================
//*   : Pick_Up
//* ˵: СǷ
//*     : AccelerationzٶȣAngleƽĽǶȣencoder_leftencoder_rightұ
//*   ֵ: 1:С  0Сδ
//============================================================================
int Pick_Up(float Acceleration,float Angle,int encoder_left,int encoder_right)
{
     static Uint16 flag,count0,count1,count2;
     if(flag==0)                                                      //һ
     {
            if(Cal_abs(encoder_left)+Cal_abs(encoder_right)<30)      //1Сӽֹ
            count0++;
            else
            count0=0;
            if(count0>10)
            flag=1,count0=0;
     }
     if(flag==1)                                                      //ڶ
     {
            if(++count1>200)       count1=0,flag=0;                       //ʱٵȴ2000msصһ
            if(Acceleration>26000&&(Angle>(-20+Middle_angle))&&(Angle<(20+Middle_angle)))   //2С0ȸ
            flag=2;
     }
     if(flag==2)                                                       //
     {
          if(++count2>100)       count2=0,flag=0;                        //ʱٵȴ1000ms
        if(Cal_abs(encoder_left+encoder_right)>70)                       //3С̥Ϊﵽת
      {
                flag=0;
                return 1;                                                    //⵽С
            }
     }
    return 0;
}

//============================================================================
//*   : Put_Down
//* ˵: СǷ񱻷
//*     : ƽǶȣұ
//*   ֵ: 1С   0Сδ
//============================================================================
int Put_Down(float Angle,int encoder_left,int encoder_right)
{
     static Uint16 flag,count;
     if(Flag_Stop==0)                     //ֹ
            return 0;
     if(flag==0)
     {
            if(Angle>(-10+Middle_angle)&&Angle<(10+Middle_angle)&&encoder_left==0&&encoder_right==0) //1С0ȸ
            flag=1;
     }
     if(flag==1)
     {
          if(++count>50)                     //ʱٵȴ 500ms
          {
                count=0;flag=0;
          }
        if(encoder_left>3&&encoder_right>3&&encoder_left<40&&encoder_right<40) //2С̥δϵʱΪת
      {
                flag=0;
                flag=0;
                return 1;                         //⵽С
            }
     }
    return 0;
}
//---------------------------------------------------------------------------
// INT_ISR for ADC-SOCA:
//---------------------------------------------------------------------------
// INT1.1
__interrupt void ADCINT1_ISR(void)   // ADC  (Can also be ISR for INT10.1 when enabled)
{
  // Insert ISR Code here

    AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;   // clear ADCINT1 flag reinitialize for next SOC
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

}



//---------------------------------------------------------------------------
// INT_ISR for SCI-A:
//---------------------------------------------------------------------------
// INT9.1
__interrupt void SCIRXINTA_ISR(void)     // SCI-A
{

    // Insert ISR Code here

    Uint8 u8Tmp;

    u8Tmp = SciaRegs.SCIRXBUF.all;
    QueDataIn(pSciIndex[ID_SCIA]->pqRx,u8Tmp);

    SciaRegs.SCIFFRX.bit.RXFFOVRCLR = 1;    // Clear Overflow flag
    SciaRegs.SCIFFRX.bit.RXFFINTCLR = 1;    // Clear Interrupt flag

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP9; // Must acknowledge the PIE group

}


//---------------------------------------------------------------------------
// INT_ISR for LIN-A:
//---------------------------------------------------------------------------
// INT9.3
__interrupt void LIN0INTA_ISR(void)     // LIN-A
{
    Uint8 u8Tmp;

    u8Tmp = LinaRegs.SCIRD & 0x00ff;
    QueDataIn(pSciIndex[ID_LINA]->pqRx,u8Tmp);

    LinaRegs.SCIFLR.bit.RXRDY       = 1;                // Clear RXRDY flag
    PieCtrlRegs.PIEACK.all          = PIEACK_GROUP9;    // Acknowledge this interrupt

}

//---------------------------------------------------------------------------
// INT_ISR for CPU-Timer0:
//---------------------------------------------------------------------------
__interrupt void  TINT0_ISR(void)      // CPU-Timer 0
{
  // Insert ISR Code here
    IER |= M_INT1;                    //Enable group_1 interrupt
    EINT;

    CpuTimer0Regs.TCR.bit.TIF = 1;    // clear flag
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

}

//---------------------------------------------------------------------------
// INT_ISR for CPU-Timer1:
//---------------------------------------------------------------------------
__interrupt void INT13_ISR(void)     // CPU-Timer1
{

    int Balance_Pwm,Velocity_Pwm,Turn_Pwm;              //ƽ⻷PWMٶȻPWMתPWM


    IER |= M_INT1;                //Enable group_1 interrupt
    EINT;

    CpuTimer1Regs.TCR.bit.TIF = 1;// clear flag

// Insert ISR Code here

    TEST1_H;
    TEST2_TOGGLE;

    Key_Scan();                                 //ɨ谴״̬
    Laser_Scan();                               //ȡɨ
    Bat_volt=Get_battery_volt();                //ȡصѹ
    UR_distance=Get_Distance();                 //ȡֵ
    Encoder_Left=Read_Encoder(Left);            //ȡֱֵǰΪΪ
    Encoder_Right=Read_Encoder(Right);          //ȡֱֵǰΪΪ
    Get_Velocity_Form_Encoder(Encoder_Left,Encoder_Right);    //㳵ٶȣmm/s
    Get_Angle(Way_Angle);                       //̬10msһΣߵĲƵʿԸƿ˲ͻ˲Ч

    Balance_Pwm=Balance(Angle_Balance,Gyro_Balance);    //ƽPID Gyro_BalanceƽٶȼԣǰΪΪ
    Velocity_Pwm=Velocity(Encoder_Left,Encoder_Right);  //ٶȻPID  סٶȷСʱҪҪܿһ
    Turn_Pwm=Turn(Gyro_Turn);


    Motor_Left=Balance_Pwm+Velocity_Pwm+Turn_Pwm;       //ֵPWM
    Motor_Right=Balance_Pwm+Velocity_Pwm-Turn_Pwm;      //ֵPWM
                                                        //PWMֵʹСǰʹС
//    uwScope[1]=Motor_Left;
//    uwScope[2]=Motor_Right;


    Motor_Left=Output_Limit(Motor_Left,5800,-5800);
    Motor_Right=Output_Limit(Motor_Right,5800,-5800);          //PWM޷

    if(Pick_Up(Acceleration_Z,Angle_Balance,Encoder_Left,Encoder_Right))//ǷС
    Flag_Stop=1;                                                //͹رյ
    if(Put_Down(Angle_Balance,Encoder_Left,Encoder_Right))   //ǷС
    Flag_Stop=0;                                                //¾
    Choose(Encoder_Left,Encoder_Right);                     //תѡСģʽ
    if(Turn_Off(Angle_Balance,Bat_volt)==0)                  //쳣
    Set_Pwm(Motor_Left,Motor_Right);                    //ֵPWMĴ



    uwScope[5]=Balance_Pwm;
    uwScope[6]=Velocity_Pwm;
    uwScope[7]=Turn_Pwm;


    IPOMS_SnatchGraph();
    TEST1_L;
}

//=============================================================================
// End of file.
//=============================================================================
