/******************************************************************************
 *    FILENAME : User_Queue.c
 *
 *    PURPOSE  :
 *
 *       Author: С                      Created on: 2025912
******************************************************************************/
#include "User_Include.h"
#include "User_Queue.h"
/*============================================================================*/

SciStruct   SciList[MAX_SCI_NO];

SciStruct   *pSciIndex[MAX_SCI_NO] = {NULL, NULL};

QUEUE       QList[MAX_SCI_NO];
Uint8       szSciRxBuf[MAX_SCI_BUF_SIZE];
Uint8       *pSciBuf = szSciRxBuf;
Uint8       u8SciNO = 0;

//---------------------------------------------------------------------------
// InitQueue:
//---------------------------------------------------------------------------
void InitQueue(QUEUE *pQue, Uint8 *pStart, Uint16 u16BufSize)
{
    pQue->u16Length = 0;
    pQue->u16Size = u16BufSize;
    pQue->pIn = pStart;
    pQue->pOut = pStart;
    pQue->pStart = pStart;
}
//---------------------------------------------------------------------------
// QueDataIn:
//---------------------------------------------------------------------------
Uint16 QueDataIn(QUEUE *pQue, Uint16 u16QueData)
{
    if(pQue->u16Length == pQue->u16Size)
    {
        if(pQue->pIn == pQue->pStart)
        {
            *(pQue->pStart + pQue->u16Size - 1) = u16QueData;
        }
        else
        {
            *(pQue->pIn - 1) = u16QueData;
        }
        return QUE_BUF_FULL;
    }
    else
    {
        *(pQue->pIn) = u16QueData;
        pQue->u16Length += 1;
        if(pQue->pIn == pQue->pStart + pQue->u16Size - 1)
        {
            pQue->pIn = pQue->pStart;
        }
        else
        {
            pQue->pIn += 1;
        }
        return QUE_BUF_NORMAL;
    }
}
//---------------------------------------------------------------------------
// QueDataOut:
//---------------------------------------------------------------------------
Uint16 QueDataOut(QUEUE *pQue, Uint8 *pQueData)
{
    if(0 == pQue->u16Length)
    {
        return QUE_BUF_EMPTY;
    }
    else
    {
        *pQueData = *(pQue->pOut);
        pQue->u16Length -= 1;
        if(pQue->pOut == (pQue->pStart + pQue->u16Size - 1))
        {
            pQue->pOut = pQue->pStart;
        }
        else
        {
            pQue->pOut += 1;
        }
        return QUE_BUF_NORMAL;
    }
}


//=============================================================================
// *  FUNCTION:  SetSci()
// *
// *  PURPOSE :  Receives data from SCI.
//=============================================================================

void SetSci(Uint16 SciId, Uint8 *pStartAddr, Uint16 u16Size)
{
    SciStruct   *pSci;
    QUEUE       *pq;

    if( NULL == pSciIndex[SciId] )
    {
        pSci = &SciList[u8SciNO];
        pSciIndex[SciId] = pSci;

        pSci->pqRx = &QList[u8SciNO];
        pq = pSci->pqRx;
        InitQueue(pq, pSciBuf, u16Size);
        pSciBuf += u16Size;
        u8SciNO += 1;

        pSci->u8TxStatus = SCI_TX_RDY;
        pSci->u16TxLength = 0;
    }
}


//=============================================================================
// *  FUNCTION:  SciRead()
// *
// *  PURPOSE :  Receives data from SCI.
//=============================================================================

Uint16 SciRead(Uint16 SciId, Uint8 *pBuf)
{
    Uint16      u16Tmp;
    QUEUE       *pq;
    SciStruct   *pSci;

    pSci = pSciIndex[SciId];
    pq = pSci->pqRx;
    u16Tmp = QueDataOut(pq, pBuf);
    if(u16Tmp == QUE_BUF_EMPTY)
    {
        return SCI_RX_EMPTY;
    }
    else
    {
        return SCI_RX_RDY;
    }
}

//=============================================================================
// End of file.
//=============================================================================

