//##############################################################################
// *  User_Queue.h
// *
// *  Created on: 2025912
// *      Author: С
//##############################################################################
#ifndef QUEUE_H_
#define QUEUE_H_

//==============================================================================
// *  Global Defines for system level initialization
//==============================================================================

#define NULL                            0

#define ID_SCIA                         0
#define ID_LINA                         1

#define ID_IPOMS                        ID_SCIA
#define FLASH_COM                       ID_LINA

#define MODE_INT                        0
#define MODE_INQUIRE                    1

#define QUE_BUF_NORMAL                  0
#define QUE_BUF_FULL                    1
#define QUE_BUF_EMPTY                   2

#define SCI_TX_RDY                      0
#define SCI_TX_BUSY                     1

#define SCI_RX_RDY                      0
#define SCI_RX_EMPTY                    1

#define MAX_SCI_NO                      2
#define SCIA_BUF_SIZE                   128
#define LINA_BUF_SIZE                   64
#define MAX_SCI_BUF_SIZE                (SCIA_BUF_SIZE + LINA_BUF_SIZE)


//==============================================================================
// *  Global Variables for system level initialization
//==============================================================================

// Queue structure
typedef struct{
    Uint8   *pIn;
    Uint8   *pOut;
    Uint8   *pStart;
    Uint16  u16Length;
    Uint16  u16Size;
}QUEUE;

//  Sci structure
typedef struct{
    Uint8   u8TxStatus;
    Uint16  u16TxLength;
    QUEUE   *pqRx;
}SciStruct;

extern Uint8        *pSciBuf;
extern SciStruct    *pSciIndex[];

//==============================================================================
// *  Global functions for system level initialization
//==============================================================================
extern Uint16       QueDataIn(QUEUE *pQue, Uint16 u16QueData);
extern Uint16       QueDataOut(QUEUE *pQue, Uint8 *pQueData);
extern Uint16       SciRead(Uint16 SciId, Uint8 *pBuf);
extern void         SetSci(Uint16 SciId, Uint8 *pStartAddr, Uint16 u16Size);

//==============================================================================
// No more.
//==============================================================================
#endif /* QUEUE_H_ */
